/*
 * Decompiled with CFR 0.152.
 */
package electric.registry;

import electric.directory.DirectoryException;
import electric.directory.IDirectory;
import electric.proxy.IProxy;
import electric.proxy.IReference;
import electric.proxy.handler.Proxy;
import electric.registry.IRegistry;
import electric.registry.IRegistryListener;
import electric.registry.RegistryException;
import electric.registry.compound.CompoundRegistry;
import electric.registry.directory.DirectoryRegistry;
import electric.server.IServer;
import electric.server.Servers;
import electric.service.IService;
import electric.service.IServiceFactory;
import electric.service.wrapper.ServiceWrapper;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.license.License;
import electric.util.license.LicensingException;
import electric.util.product.Product;
import electric.util.proxy.ProxyFactory;
import electric.util.string.Strings;

public final class Registry {
    private static final CompoundRegistry compoundRegistry = new CompoundRegistry();
    private static final DirectoryRegistry root = new DirectoryRegistry();
    private static IServiceFactory serviceFactory = new ServiceWrapper();
    static /* synthetic */ Class class$electric$util$context$IContextHolder;

    public static void startup() {
        Registry.addRegistry("root", root);
    }

    public static void setDirectory(String path, IDirectory directory) throws DirectoryException {
        root.setDirectory(path, directory);
    }

    public static IDirectory getDirectory(String path) throws DirectoryException {
        return root.getDirectory(path);
    }

    public static void addRegistry(String name, IRegistry registry) {
        compoundRegistry.addRegistry(name, registry);
    }

    public static void addRegistry(String name, IRegistry registry, float priority) {
        compoundRegistry.addRegistry(name, registry, priority);
    }

    public static IRegistry getRegistry(String name) {
        return compoundRegistry.getRegistry(name);
    }

    public static IRegistry removeRegistry(String name) {
        return compoundRegistry.removeRegistry(name);
    }

    public static CompoundRegistry getCompoundRegistry() {
        return compoundRegistry;
    }

    public static Object bind(String path, Class type) throws RegistryException {
        return Registry.bind(path, new Class[]{type}, new Context());
    }

    public static Object bind(String path, Class[] types) throws RegistryException {
        return Registry.bind(path, types, new Context());
    }

    public static Object bind(String path, Class type, Context context) throws RegistryException {
        return Registry.bind(path, new Class[]{type}, context);
    }

    public static Object bind(String path, Class[] types, Context context) throws RegistryException {
        Proxy proxy = Registry.getProxy(path, types, context);
        return Registry.newProxy(proxy, types);
    }

    public static IProxy bind(String path) throws RegistryException {
        return Registry.getProxy(path, null, new Context());
    }

    public static IProxy bind(String path, Context context) throws RegistryException {
        return Registry.getProxy(path, null, context);
    }

    private static Proxy getProxy(String path, Class[] types, Context context) throws RegistryException {
        IReference reference = Registry.getReference(path, types, context);
        return new Proxy(reference, context);
    }

    public static IReference getReference(String path, Class[] interfaces, Context context) throws RegistryException {
        IReference reference = compoundRegistry.bind(path, interfaces, context);
        if (reference == null) {
            throw new RegistryException("could not bind to " + path);
        }
        return reference;
    }

    public static Object bind(Class type) throws RegistryException {
        return Registry.bind(null, type);
    }

    public static Object bind(Class[] types) throws RegistryException {
        return Registry.bind(null, types);
    }

    public static Object bind(Class type, Context context) throws RegistryException {
        return Registry.bind(null, type, context);
    }

    public static Object bind(Class[] types, Context context) throws RegistryException {
        return Registry.bind(null, types, context);
    }

    public static Object newProxy(Proxy proxy, Class[] types) {
        ClassLoader loader = proxy.getReference().getClass().getClassLoader();
        Class[] interfaces = (Class[])ArrayUtil.addElement(types, class$electric$util$context$IContextHolder == null ? (class$electric$util$context$IContextHolder = Registry.class$("electric.util.context.IContextHolder")) : class$electric$util$context$IContextHolder);
        return ProxyFactory.newProxy(loader, interfaces, proxy);
    }

    public static void publish(String path, Object object) throws RegistryException {
        Registry.publish(path, object, new Context());
    }

    public static void publish(String path, Object object, Context context) throws RegistryException {
        if (License.isClientLicense()) {
            throw new LicensingException("Service publishing is disabled. Contact TME Sales to obtain a server side license");
        }
        IService service = Registry.newService(object);
        context.addContext(service.getContext());
        service.setContext(context);
        if (!compoundRegistry.publish(path, service, context)) {
            throw new RegistryException("cannot publish " + object);
        }
    }

    public static void publish(String path, Object object, Class type) throws RegistryException {
        Registry.publish(path, object, new Class[]{type});
    }

    public static void publish(String path, Object object, Class type, Context context) throws RegistryException {
        Registry.publish(path, object, new Class[]{type}, context);
    }

    public static void publish(String path, Object object, Class[] types) throws RegistryException {
        Registry.publish(path, object, types, new Context());
    }

    public static void publish(String path, Object object, Class[] types, Context context) throws RegistryException {
        int i = 0;
        while (i < types.length) {
            context.addProperty("interface", types[i].getName());
            ++i;
        }
        Registry.publish(path, object, context);
    }

    public static void unpublish(String path) throws RegistryException {
        if (!compoundRegistry.unpublish(path)) {
            throw new RegistryException("cannot unpublish " + path);
        }
    }

    public static IServiceFactory getServiceFactory() {
        return serviceFactory;
    }

    public static void setServiceFactory(IServiceFactory serviceFactory) {
        Registry.serviceFactory = serviceFactory;
    }

    private static IService newService(Object object) throws RegistryException {
        try {
            return serviceFactory.newService(object);
        }
        catch (Exception exception) {
            throw new RegistryException(exception);
        }
    }

    public static Object get(String path) throws RegistryException {
        return root.get(path);
    }

    public static IService getService(String path) throws RegistryException {
        try {
            if (XURL.hasProtocol(path)) {
                XURL xurl = new XURL(path);
                IServer server = Servers.getServerForPath(xurl);
                if (server == null) {
                    return null;
                }
                path = server.getLocalPath(xurl.getFile());
            }
            return (IService)(path == null ? null : root.get(path));
        }
        catch (Throwable throwable) {
            throw new RegistryException(throwable);
        }
    }

    public static IService getService(Object object) throws RegistryException {
        try {
            String path = root.getDirectory().getPath(object);
            return (IService)(path == null ? null : root.get(path));
        }
        catch (DirectoryException exception) {
            throw new RegistryException(exception);
        }
    }

    public static IRegistryListener addListener(String name, IRegistryListener listener) {
        return compoundRegistry.addListener(name, listener);
    }

    public static IRegistryListener getListener(String name) {
        return compoundRegistry.getListener(name);
    }

    public static IRegistryListener removeListener(String name) {
        return compoundRegistry.removeListener(name);
    }

    public static String getPath(String name, Object object) {
        if (name.startsWith("/")) {
            if (name.length() > 1 && name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            try {
                return root.getDirectory(name).getPath(object);
            }
            catch (Exception exception) {
                return null;
            }
        }
        IServer server = Servers.getServer(name);
        return server == null ? null : Registry.getPath(server, object);
    }

    public static String getPath(IServer server, Object object) {
        try {
            String path;
            String name = server.getRoot();
            if (name.length() > 1 && name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            if ((path = root.getDirectory(name).getPath(object)) == null) {
                return null;
            }
            return Strings.splice(server.getPath().toString(), path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getPath(Object object) {
        IServer[] servers = Servers.getServers();
        int i = 0;
        while (i < servers.length) {
            String path;
            IServer server = servers[i];
            if (server.getRoot() != null && (path = Registry.getPath(server, object)) != null) {
                return path;
            }
            ++i;
        }
        return null;
    }

    public static String[] getAllPaths(Object object) {
        IServer[] servers = Servers.getServers();
        String[] paths = new String[]{};
        int i = 0;
        while (i < servers.length) {
            String path;
            IServer server = servers[i];
            if (server.getRoot() != null && (path = Registry.getPath(server, object)) != null) {
                paths = (String[])ArrayUtil.addElement(paths, path);
            }
            ++i;
        }
        return paths;
    }

    public static String getRegistryPath(Object object) throws DirectoryException {
        return root.getDirectory().getPath(object);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Product.startup();
    }
}

