/*
 * Decompiled with CFR 0.152.
 */
package electric.proxy.tools;

import electric.proxy.IProxy;
import electric.registry.Registry;
import electric.util.array.ArrayUtil;
import electric.util.product.Product;
import electric.util.string.Strings;
import electric.util.tool.ToolUtil;
import electric.xml.io.Mappings;

public class Invoke {
    private static String path = null;
    private static String method = null;
    private static String[] parameters = new String[0];

    public static void main(String[] args) {
        if (args.length == 0) {
            Invoke.printUsage();
            return;
        }
        try {
            Invoke.processArgs(args);
            Product.startup();
            Invoke.invoke();
        }
        catch (Throwable throwable) {
            System.out.println("error: " + throwable.getMessage());
            Invoke.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: invoke [-Dname=value]* url method arg1 arg2 ... [-h] [-i path]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value = set java system property");
        System.out.println("  url          = url of wsdl for web service");
        System.out.println("  method       = name of the method to invoke");
        System.out.println("  argX         = the Xth argument, expressed as a string");
        System.out.println("  -h           = print help and exit");
        System.out.println("  -i path      = input path for map files, '.' by default");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("invoke http://localhost:8004/glue/exchange.wsdl getRate usa japan");
        System.out.println("  invoke getRate( \"usa\", \"japan\" ) on web service with specified WSDL address");
    }

    private static void processArgs(String[] args) throws Throwable {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                if (path == null) {
                    path = arg;
                } else if (method == null) {
                    method = arg;
                } else {
                    parameters = (String[])ArrayUtil.addElement(parameters, arg);
                }
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'i': {
                        String mapPath = Strings.getString("i", args, ++i);
                        Mappings.readMappings(mapPath);
                        break;
                    }
                    case 'D': {
                        ToolUtil.setProperty(arg);
                        break;
                    }
                    case 'h': {
                        Invoke.printUsage();
                        System.exit(-1);
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
    }

    private static void invoke() {
        try {
            IProxy proxy = Registry.bind(path);
            Object result = proxy.invoke(method, parameters);
            System.out.println("result = " + result);
        }
        catch (Throwable throwable) {
            System.out.println("exception: " + throwable.toString());
        }
    }
}

