/*
 * Decompiled with CFR 0.152.
 */
package electric.net.socket;

import electric.glue.IGLUELoggingConstants;
import electric.net.channel.ChannelsInUse;
import electric.net.channel.IChannel;
import electric.net.channel.IChannelListener;
import electric.net.channel.IChannelSink;
import electric.net.socket.SocketChannel;
import electric.net.socket.SocketFactories;
import electric.net.socket.SocketRequest;
import electric.util.Context;
import electric.util.XURL;
import electric.util.classloader.ClassLoaders;
import electric.util.license.Enabler;
import electric.util.list.LinkedList;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.thread.ThreadPool;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public final class SocketServer
implements Runnable,
IGLUELoggingConstants,
IChannelListener {
    private static int maxKeepAlive = 5;
    private static int keptAliveCount = 0;
    private static int defaultBacklog = 200;
    private static int connectionLimit = -1;
    private static int connectionCount = 0;
    private int backlog;
    private IChannelSink sink;
    private boolean running = false;
    private boolean shutdown = false;
    private XURL xurl;
    private ServerSocket serverSocket;
    private ThreadPool threadPool;
    private ChannelsInUse channelsInUse = new ChannelsInUse();
    private long bytesRead;
    private long bytesWritten;

    public SocketServer(XURL xurl, int backlog, ThreadPool threadPool, IChannelSink sink) throws IOException {
        this.xurl = xurl;
        this.serverSocket = SocketFactories.createServerSocket(xurl, backlog);
        if (xurl.getPort() == 0) {
            int port = this.serverSocket.getLocalPort();
            this.xurl = new XURL(xurl.getProtocol(), xurl.getHost(), port, xurl.getFile(), xurl.getReference());
        }
        this.backlog = backlog;
        this.threadPool = threadPool;
        this.sink = sink;
    }

    public synchronized void startup() throws IOException {
        if (!this.running) {
            this.running = true;
            if (this.shutdown) {
                this.serverSocket = SocketFactories.createServerSocket(this.xurl, this.backlog);
            }
            Thread thread = new Thread(this);
            thread.setName("SocketServer:" + thread.getName());
            thread.setDaemon(false);
            thread.start();
        }
    }

    public void shutdown() {
        this.running = false;
        this.shutdown = true;
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {}
    }

    public void run() {
        while (this.running) {
            try {
                if (connectionLimit != -1) {
                    this.blockUntilUnderConnectionLimit();
                }
                Socket socket = this.serverSocket.accept();
                ++connectionCount;
                try {
                    SocketChannel channel = new SocketChannel(socket, this.xurl.getProtocol());
                    channel.setState(1);
                    this.channelsInUse.add(channel);
                    this.threadPool.run(new SocketRequest(this, channel));
                }
                catch (IOException exception) {
                    this.shutdown();
                }
            }
            catch (Throwable exception) {
                if (this.running) {
                    System.out.println("debug: java.home = " + Context.getSystemProperty("java.home"));
                    exception.printStackTrace();
                }
                this.shutdown();
            }
        }
    }

    public void run(SocketRequest request) {
        block10: {
            SocketChannel channel = request.getChannel();
            try {
                if (channel.getState() == 1) {
                    channel.setState(0);
                }
                if (!this.sink.service(channel)) {
                    channel.setKeepAlive(false);
                } else if (channel.getKeepAlive() && !channel.getKeptAlive()) {
                    this.determineKeepAlive(channel);
                }
                if (channel.getKeepAlive()) {
                    channel.setState(2);
                    this.threadPool.run(request);
                    break block10;
                }
                this.shutdown(channel);
            }
            catch (Exception exception) {
                if (this.isSSLException(exception)) {
                    if (Log.isLogging(ILoggingConstants.SECURITY_EVENT)) {
                        Log.log(ILoggingConstants.SECURITY_EVENT, (Object)("problem accepting ssl connection from: " + channel.getRemoteXURL() + ", " + exception.toString()));
                    }
                    if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                        Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                    }
                }
                this.shutdown(channel);
            }
        }
    }

    private synchronized void determineKeepAlive(SocketChannel channel) {
        if (keptAliveCount >= maxKeepAlive) {
            channel.setKeepAlive(false);
        } else {
            channel.setKeptAlive(true);
            ++keptAliveCount;
        }
    }

    private synchronized void shutdown(SocketChannel channel) {
        try {
            this.channelsInUse.remove(channel);
            channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (channel.getKeptAlive()) {
            --keptAliveCount;
        }
        --connectionCount;
        this.notify();
    }

    public static int getMaxKeepAlive() {
        return maxKeepAlive;
    }

    public static void setMaxKeepAlive(int max) {
        maxKeepAlive = max;
    }

    public static void setDefaultBacklog(int backlog) {
        defaultBacklog = backlog;
    }

    public static int getDefaultBacklog() {
        return defaultBacklog;
    }

    public XURL getXURL() {
        return this.xurl;
    }

    public static void setConnectionLimit(int limit) {
        if (limit == -1) {
            return;
        }
        if (Enabler.enable()) {
            connectionLimit = limit;
        }
    }

    private synchronized void blockUntilUnderConnectionLimit() {
        while (connectionCount > connectionLimit) {
            try {
                this.wait();
            }
            catch (InterruptedException exception) {
                // empty catch block
            }
        }
    }

    private boolean isSSLException(Exception exception) {
        try {
            Class sslExceptionClass = ClassLoaders.loadClass("javax.net.ssl.SSLException");
            return sslExceptionClass.isAssignableFrom(exception.getClass());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public LinkedList getChannels() {
        return this.channelsInUse.getChannels();
    }

    public void channelShutdown(IChannel channel) {
        this.bytesRead += channel.getBytesRead();
        this.bytesWritten += channel.getBytesWritten();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }
}

