/*
 * Decompiled with CFR 0.152.
 */
package electric.net.channel;

import electric.net.channel.CachedChannel;
import electric.net.channel.IChannel;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ChannelPool {
    private static int DEFAULT_MAX_CACHE_SIZE = 5;
    private int size = 0;
    private Hashtable cache = new Hashtable();
    private int maxCacheSize = DEFAULT_MAX_CACHE_SIZE;

    public ChannelPool() {
        this.maxCacheSize = DEFAULT_MAX_CACHE_SIZE;
    }

    public ChannelPool(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public synchronized IChannel get(XURL xurl) throws IOException {
        CachedChannel[] channels = (CachedChannel[])this.cache.get(xurl);
        if (channels == null) {
            return null;
        }
        CachedChannel cachedChannel = channels[0];
        this.remove(xurl, channels, 0);
        return cachedChannel.channel;
    }

    public synchronized IChannel peek(XURL xurl) {
        CachedChannel[] channels = (CachedChannel[])this.cache.get(xurl);
        return channels == null ? null : channels[0].channel;
    }

    public synchronized void put(XURL xurl, IChannel channel) {
        while (this.size >= this.maxCacheSize) {
            this.flushOldest();
        }
        CachedChannel[] channels = (CachedChannel[])this.cache.get(xurl);
        CachedChannel cachedChannel = new CachedChannel(channel, System.currentTimeMillis());
        if (channels == null) {
            this.cache.put(xurl, new CachedChannel[]{cachedChannel});
        } else {
            this.cache.put(xurl, ArrayUtil.addElement(channels, cachedChannel));
        }
        ++this.size;
    }

    private void remove(XURL xurl, CachedChannel[] channels, int index) {
        if (channels.length == 1) {
            this.cache.remove(xurl);
        } else {
            this.cache.put(xurl, ArrayUtil.removeElementAt(channels, index));
        }
        --this.size;
    }

    public synchronized void flush(XURL xurl) {
        CachedChannel[] channels = (CachedChannel[])this.cache.remove(xurl);
        if (channels != null) {
            this.close(channels);
        }
    }

    private void flushOldest() {
        XURL channelXURL = null;
        CachedChannel[] channels = null;
        int index = 0;
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            XURL xurl = (XURL)enumeration.nextElement();
            CachedChannel[] array = (CachedChannel[])this.cache.get(xurl);
            int i = 0;
            while (i < array.length) {
                if (channels == null || array[i].cachedTime < channels[index].cachedTime) {
                    channelXURL = xurl;
                    channels = array;
                    index = i;
                }
                ++i;
            }
        }
        try {
            channels[index].channel.close();
        }
        catch (IOException exception) {
            // empty catch block
        }
        this.remove(channelXURL, channels, index);
    }

    public synchronized void shutdown() {
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            this.close((CachedChannel[])enumeration.nextElement());
        }
        this.cache.clear();
    }

    private void close(CachedChannel[] channels) {
        int i = 0;
        while (i < channels.length) {
            try {
                channels[i].channel.close();
            }
            catch (IOException exception) {
                // empty catch block
            }
            --this.size;
            ++i;
        }
    }

    public static void setDefaultMaxCacheSize(int defaultMaxCacheSize) {
        DEFAULT_MAX_CACHE_SIZE = defaultMaxCacheSize;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public int getCacheSize() {
        return this.size;
    }

    public synchronized void setMaxCacheSize(int max) {
        this.maxCacheSize = max;
        while (this.size > this.maxCacheSize) {
            this.flushOldest();
        }
    }

    public synchronized XURL[] getHosts() {
        XURL[] xurls = new XURL[]{};
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            xurls = (XURL[])ArrayUtil.addElement(xurls, enumeration.nextElement());
        }
        return xurls;
    }
}

