/*
 * Decompiled with CFR 0.152.
 */
package electric.net.broadcast;

import electric.net.broadcast.IBroadcastListener;
import electric.util.UUID;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public class Broadcaster
implements Runnable,
ILoggingConstants {
    private static final String REGULAR_BROADCAST = "255.255.255.255";
    private static final String LOOPBACK_BROADCAST = "127.255.255.255";
    private boolean stopped = true;
    private int receivePort;
    private int sendPort;
    private InetAddress broadcastAddress;
    private DatagramSocket sendSocket;
    private MulticastSocket receiveSocket;
    private IBroadcastListener[] listeners = new IBroadcastListener[0];
    private Thread thread;

    public Broadcaster(int port) throws IOException {
        this(port, port);
    }

    public Broadcaster(int receivePort, int sendPort) throws IOException {
        this.receivePort = receivePort;
        this.sendPort = sendPort;
        this.sendSocket = new DatagramSocket();
        this.receiveSocket = new MulticastSocket(receivePort);
        this.broadcastAddress = this.getBroadcastAddress();
    }

    public int getReceivePort() {
        return this.receivePort;
    }

    public int getSendPort() {
        return this.sendPort;
    }

    public void startup() {
        if (!this.stopped) {
            return;
        }
        this.stopped = false;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void shutdown() {
        this.stopped = true;
        this.thread.interrupt();
    }

    public void run() {
        block6: {
            try {
                this.receiveSocket.setSoTimeout(0);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block6;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during broadcast", exception);
            }
        }
        while (!this.stopped) {
            try {
                byte[] buffer = new byte[1024];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                this.receiveSocket.receive(packet);
                byte[] data = new byte[packet.getLength()];
                System.arraycopy(buffer, 0, data, 0, packet.getLength());
                int i = 0;
                while (i < this.listeners.length) {
                    this.listeners[i].received(packet.getAddress(), packet.getPort(), data);
                    ++i;
                }
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) continue;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during broadcast", exception);
            }
        }
    }

    public void send(byte[] bytes) throws IOException {
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.broadcastAddress, this.sendPort);
        this.sendSocket.send(packet);
    }

    public void addListener(IBroadcastListener listener) {
        this.listeners = (IBroadcastListener[])ArrayUtil.addElement(this.listeners, listener);
    }

    public void removeListener(IBroadcastListener listener) {
        this.listeners = (IBroadcastListener[])ArrayUtil.removeElementIdentity(this.listeners, listener);
    }

    private InetAddress getBroadcastAddress() throws UnknownHostException {
        InetAddress address;
        InetAddress localHostAddress = XURL.getLocalHostAddress();
        byte[] bytes = localHostAddress.getAddress();
        if (bytes[0] != 127 && this.getEchoOn(address = InetAddress.getByName(REGULAR_BROADCAST))) {
            return address;
        }
        return InetAddress.getByName(LOOPBACK_BROADCAST);
    }

    private boolean getEchoOn(InetAddress address) {
        try {
            String string;
            String echoString = "<x" + new UUID().getKey() + "/>";
            byte[] echoBytes = echoString.getBytes();
            byte[] buffer = new byte[1024];
            DatagramPacket packet1 = new DatagramPacket(echoBytes, echoBytes.length, address, this.receivePort);
            this.sendSocket.send(packet1);
            DatagramPacket packet2 = new DatagramPacket(buffer, buffer.length);
            do {
                this.receiveSocket.setSoTimeout(100);
                this.receiveSocket.receive(packet2);
                byte[] data = new byte[packet2.getLength()];
                System.arraycopy(buffer, 0, data, 0, packet2.getLength());
            } while (!(string = new String(buffer, 0, packet2.getLength())).equals(echoString));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args[0].equals("server")) {
            DatagramSocket sendSocket = new DatagramSocket();
            InetAddress address = InetAddress.getByName(args[1]);
            int i = 0;
            while (true) {
                try {
                    byte[] echoBytes = ("TME:" + i++).getBytes();
                    DatagramPacket packet1 = new DatagramPacket(echoBytes, echoBytes.length, address, 9010);
                    sendSocket.send(packet1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Thread.sleep(5000L);
            }
        }
        MulticastSocket receiveSocket = new MulticastSocket(9010);
        while (true) {
            byte[] buffer = new byte[1024];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            receiveSocket.receive(packet);
            byte[] data = new byte[packet.getLength()];
            System.arraycopy(buffer, 0, data, 0, packet.getLength());
            System.out.println("received " + new String(data));
        }
    }
}

