/*
 * Decompiled with CFR 0.152.
 */
package electric.http.authentication.digest;

import electric.glue.IGLUELoggingConstants;
import electric.http.OutboundHTTPRequest;
import electric.http.authentication.IAuthSession;
import electric.security.credentials.PasswordCredentials;
import electric.util.XURL;
import electric.util.http.AuthHeaderData;
import electric.util.http.DigestUtil;
import electric.util.http.IHTTPConstants;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Base64;
import electric.util.string.Strings;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;

public class DigestAuthSession
implements IAuthSession,
IHTTPConstants,
IGLUELoggingConstants {
    private int nonceCount;
    private PasswordCredentials credentials;
    private AuthHeaderData authData = new AuthHeaderData();

    private String generateCNonce() {
        String timeStamp = Long.toString(System.currentTimeMillis());
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hashDigest = digest.digest(timeStamp.getBytes());
            return Base64.toBase64(hashDigest);
        }
        catch (NoSuchAlgorithmException exception) {
            block2: {
                if (!Log.isLogging(ILoggingConstants.SECURITY_EVENT)) break block2;
                Log.log(ILoggingConstants.SECURITY_EVENT, (Object)"Digest generateNonce failed, no MD5");
            }
            return null;
        }
    }

    private static String formatNonceCount(int nonceCount) {
        String ncStr = Integer.toHexString(nonceCount);
        while (ncStr.length() < 8) {
            ncStr = "0" + ncStr;
        }
        return ncStr;
    }

    private void incrementNonceCount() {
        ++this.nonceCount;
        this.authData.nc = DigestAuthSession.formatNonceCount(this.nonceCount);
    }

    private void zeroNonceCount() {
        this.nonceCount = 0;
        this.authData.nc = DigestAuthSession.formatNonceCount(this.nonceCount);
    }

    private void setAuthData(AuthHeaderData headerAuthData) {
        if (this.authData.nonce != null && !this.authData.nonce.equals(headerAuthData.nonce)) {
            this.zeroNonceCount();
        }
        this.authData = headerAuthData;
        this.authData.nc = DigestAuthSession.formatNonceCount(this.nonceCount);
        this.authData.cnonce = this.generateCNonce();
    }

    public PasswordCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(PasswordCredentials credentials) {
        this.credentials = new PasswordCredentials(credentials.user, credentials.password);
    }

    private static String assembleAuthHeader(String userName, String digestURI, AuthHeaderData authData, String digest) {
        StringBuffer authHeader = new StringBuffer();
        authHeader.append("username=\"");
        authHeader.append(userName);
        authHeader.append("\", realm=\"");
        authHeader.append(authData.realmName);
        authHeader.append("\", nonce=\"");
        authHeader.append(authData.nonce);
        authHeader.append("\", uri=\"");
        authHeader.append(digestURI);
        if ("auth".equals(authData.qop)) {
            authHeader.append("\", qop=\"");
            authHeader.append(authData.qop);
            authHeader.append("\", nc=");
            authHeader.append(authData.nc);
            authHeader.append(", cnonce=\"");
            authHeader.append(authData.cnonce);
        }
        authHeader.append("\", response=\"");
        authHeader.append(digest);
        authHeader.append('\"');
        if (authData.opaque != null) {
            authHeader.append(", opaque=\"");
            authHeader.append(authData.opaque);
            authHeader.append('\"');
        }
        return authHeader.toString();
    }

    public AuthHeaderData parseAuthHeader(String header) {
        AuthHeaderData authData = new AuthHeaderData();
        int spacePos = header.indexOf(" ");
        String challenge = header.substring(spacePos);
        StringTokenizer tokenizer = new StringTokenizer(challenge, ",");
        while (tokenizer.hasMoreElements()) {
            this.parseHeaderElement(tokenizer, authData);
        }
        return authData;
    }

    private void parseHeaderElement(StringTokenizer tokenizer, AuthHeaderData authData) {
        String param = tokenizer.nextToken();
        int equalPos = param.indexOf("=");
        String name = param.substring(0, equalPos);
        name = name.trim();
        String value = param.substring(equalPos + 1);
        value = Strings.stripQuotes(value);
        if ("qop".equals(name)) {
            authData.qop = value;
        } else if ("realm".equals(name)) {
            authData.realmName = value;
        } else if ("nonce".equals(name)) {
            authData.nonce = value;
        } else if ("opaque".equals(name)) {
            authData.opaque = value;
        }
    }

    public synchronized boolean authenticateRealm(XURL host, OutboundHTTPRequest request, AuthHeaderData headerAuthData) throws SecurityException {
        if (headerAuthData.realmName == null) {
            throw new SecurityException("no realm in WWW-Authenticate header ");
        }
        if (this.credentials == null) {
            throw new SecurityException("no credentials for realm " + this.authData.realmName);
        }
        this.setAuthData(headerAuthData);
        this.authData.uri = request.getRequestURI();
        this.authData.httpMethod = request.getMethod();
        this.authData.qop = headerAuthData.qop != null && headerAuthData.qop.equals("auth") ? "auth" : null;
        this.incrementNonceCount();
        String digest = this.calcDigest();
        String response = DigestAuthSession.assembleAuthHeader(this.credentials.user, request.getRequestURI(), this.authData, digest);
        request.setHeader("Authorization", "Digest " + response);
        return true;
    }

    private String calcDigest() throws SecurityException {
        try {
            this.authData.userName = this.credentials.user;
            return DigestUtil.calculateDigest(this.authData, this.credentials.password);
        }
        catch (NoSuchAlgorithmException exception) {
            throw new SecurityException("digest algorithm not found ");
        }
    }

    public void preAuthenticate(XURL host, OutboundHTTPRequest request) {
        if (this.credentials == null || this.authData.realmName == null || this.authData.nonce == null) {
            return;
        }
        this.authenticateRealm(host, request, this.authData);
    }
}

