/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.std.config;

import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.IConfigConstants;
import electric.service.descriptor.IInitializer;
import electric.service.descriptor.ServiceDescriptor;
import electric.service.wrapper.ServiceWrapper;
import electric.soap.wsdl.SOAPBinding;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.xml.Element;
import electric.xml.Elements;

public final class ServicesConfig
implements IConfig,
IConfigConstants,
IGLUELoggingConstants {
    public void config(Element config) throws Exception {
        Element services = config.getElement("services");
        if (services == null) {
            return;
        }
        Element style = services.getElement("defaultStyle");
        if (style != null) {
            SOAPBinding.setDefaultStyle(style.getString());
        }
        Elements handlers = services.getElements("initializer");
        while (handlers.hasMoreElements()) {
            Element handler = handlers.next();
            try {
                Class handlerClass = ClassLoaders.loadClass(handler.getString());
                ServiceDescriptor.addInitializer((IInitializer)handlerClass.newInstance());
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.STARTUP_EVENT)) continue;
                Log.log(ILoggingConstants.STARTUP_EVENT, "could not load an instance of IIntializer, " + handler.getString() + ".", exception);
            }
        }
        if (services.hasElement("wrapper")) {
            ServiceWrapper.setServiceWrapper(services.getString("wrapper"));
        }
    }
}

