/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.std.config;

import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.IConfigConstants;
import electric.net.socket.ISocketFactory;
import electric.net.socket.SocketFactories;
import electric.net.socket.ssl.ISSLProvider;
import electric.net.socket.ssl.SSLSocketFactory;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.util.reflect.Creator;
import electric.xml.Element;
import electric.xml.Elements;

public final class SSLConfig
implements IConfig,
IConfigConstants,
IGLUELoggingConstants {
    public void config(Element config) throws Exception {
        SSLSocketFactory sslSocketFactory;
        Element sslElement;
        block8: {
            sslElement = config.getElement("ssl");
            ISocketFactory socketFactory = SocketFactories.getFactory("ssl");
            if (sslElement == null || socketFactory == null || !(socketFactory instanceof SSLSocketFactory)) {
                return;
            }
            sslSocketFactory = (SSLSocketFactory)socketFactory;
            if (sslElement.hasElement("provider")) {
                try {
                    ISSLProvider provider = (ISSLProvider)Creator.newInstance(sslElement.getElement("provider"), null);
                    SSLSocketFactory.setSSLProvider(provider);
                }
                catch (Throwable throwable) {
                    if (!Log.isLogging(ILoggingConstants.STARTUP_EVENT)) break block8;
                    Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("could not materialize ssl provider " + sslElement.getElement("provider") + "\n" + throwable.toString()));
                }
            }
        }
        if (sslElement.hasElement("serverNeedsClientAuth")) {
            sslSocketFactory.setServerSocketNeedsClientAuth(sslElement.getBoolean("serverNeedsClientAuth"));
        }
        if (sslElement.hasElement("clientNeedsClientAuth")) {
            sslSocketFactory.setClientSocketNeedsClientAuth(sslElement.getBoolean("clientNeedsClientAuth"));
        }
        Elements cipherSuites = sslElement.getElements("clientCipherSuite");
        while (cipherSuites.hasMoreElements()) {
            sslSocketFactory.addClientCipherSuite(cipherSuites.next().getTextString());
        }
        cipherSuites = sslElement.getElements("serverCipherSuite");
        while (cipherSuites.hasMoreElements()) {
            sslSocketFactory.addServerCipherSuite(cipherSuites.next().getTextString());
        }
    }
}

