/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.std.config;

import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.IConfigConstants;
import electric.soap.references.ISOAPReferenceFactory;
import electric.soap.references.SOAPReferenceFactories;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.util.reflect.Creator;
import electric.xml.Element;
import electric.xml.Elements;

public final class SOAPReferenceFactoryConfig
implements IConfig,
IConfigConstants,
IGLUELoggingConstants {
    public void config(Element config) {
        Element referenceFactories = config.getElement("soapReferenceFactories");
        if (referenceFactories == null) {
            return;
        }
        Elements factories = referenceFactories.getElements("factory");
        while (factories.hasMoreElements()) {
            Element factoryElement = factories.next();
            String name = factoryElement.getString("name");
            String priority = factoryElement.getString("priority");
            try {
                ISOAPReferenceFactory factory = (ISOAPReferenceFactory)Creator.newInstance(factoryElement, null);
                if (priority != null) {
                    SOAPReferenceFactories.addFactory(name, factory, Float.parseFloat(priority));
                    continue;
                }
                SOAPReferenceFactories.addFactory(name, factory);
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.STARTUP_EVENT)) continue;
                Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("could not materialize soap reference factory " + factoryElement + "\n" + throwable.toString()));
            }
        }
    }
}

