/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.std.config;

import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.IConfigConstants;
import electric.soap.handlers.ISOAPHandlerFactory;
import electric.soap.handlers.SOAPHandlerFactories;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.util.reflect.Creator;
import electric.xml.Element;
import electric.xml.Elements;

public final class SOAPHandlerFactoryConfig
implements IConfig,
IConfigConstants,
IGLUELoggingConstants {
    public void config(Element config) {
        Element handlerFactories = config.getElement("soapHandlerFactories");
        if (handlerFactories == null) {
            return;
        }
        Elements factories = handlerFactories.getElements("factory");
        while (factories.hasMoreElements()) {
            Element factoryElement = factories.next();
            String name = factoryElement.getString("name");
            String priority = factoryElement.getString("priority");
            try {
                ISOAPHandlerFactory factory = (ISOAPHandlerFactory)Creator.newInstance(factoryElement, null);
                if (priority != null) {
                    SOAPHandlerFactories.addFactory(name, factory, Float.parseFloat(priority));
                    continue;
                }
                SOAPHandlerFactories.addFactory(name, factory);
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.STARTUP_EVENT)) continue;
                Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("could not materialize soap reference factory " + factoryElement + "\n" + throwable.toString()));
            }
        }
    }
}

