/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.console.services;

import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.glue.pro.console.services.ConsoleLogger;
import electric.glue.pro.console.services.ILogConstants;
import electric.glue.pro.console.services.ILoggerListener;
import electric.util.UUID;
import electric.util.log.ILogger;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.log.WriterLogger;
import electric.util.reflect.Creator;
import electric.xml.CData;
import electric.xml.Document;
import electric.xml.Element;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class Logging
implements ILoggerListener,
ILoggingConstants,
IConsoleModule,
ITreeViewProducer,
ILogConstants,
IConsoleConstants {
    private static final int MAX_CACHED_ENTRIES = 20;
    private static final String CONSOLELOGGER_PREFIX = "consoleLogger-";
    private Hashtable sessions = new Hashtable();
    private ConsoleModuleInfo moduleInfo;

    public Document getLoggingInfo(Hashtable args) {
        int totalLoggers = 0;
        int totalCategories = 0;
        Document doc = new Document();
        Element root = doc.setRoot("Logging");
        if (args.containsKey("details")) {
            Element loggers = root.addElement("loggers");
            Enumeration loggerNames = Log.getLoggerNames();
            while (loggerNames.hasMoreElements()) {
                String loggerName = (String)loggerNames.nextElement();
                if (loggerName.startsWith(CONSOLELOGGER_PREFIX)) {
                    --totalLoggers;
                } else {
                    Element loggerElement = loggers.addElement("logger");
                    loggerElement.setText("name", loggerName);
                    ILogger logger = Log.getLogger(loggerName);
                    loggerElement.setText("enabled", logger.isEnabled() ? "yes" : "no");
                    Enumeration cats = Log.getCategories();
                    while (cats.hasMoreElements()) {
                        String category = (String)cats.nextElement();
                        Element categoryElement = loggerElement.addElement("category");
                        categoryElement.setText(category);
                        categoryElement.setAttribute("enabled", logger.isLogging(category) ? "yes" : "no");
                        ++totalCategories;
                    }
                }
                ++totalLoggers;
            }
        } else {
            Enumeration loggerNames = Log.getLoggerNames();
            while (loggerNames.hasMoreElements()) {
                String loggerName = (String)loggerNames.nextElement();
                if (loggerName.startsWith(CONSOLELOGGER_PREFIX)) {
                    --totalLoggers;
                }
                ++totalLoggers;
            }
            Enumeration cats = Log.getCategories();
            while (cats.hasMoreElements()) {
                cats.nextElement();
                ++totalCategories;
            }
        }
        root.setInt("totalLoggers", totalLoggers);
        root.setInt("totalCategories", totalCategories / totalLoggers);
        return doc;
    }

    public void enableLogger(Hashtable args) {
        String loggerName = ((String)args.get("loggerName")).trim();
        ILogger logger = Log.getLogger(loggerName);
        logger.enable();
    }

    public void disableLogger(Hashtable args) {
        String loggerName = ((String)args.get("loggerName")).trim();
        ILogger logger = Log.getLogger(loggerName);
        logger.disable();
    }

    public void enableCategory(Hashtable args) {
        String loggerName = (String)args.get("loggerName");
        String category = (String)args.get("category");
        ILogger logger = Log.getLogger(loggerName);
        logger.startLogging(category);
    }

    public void disableCategory(Hashtable args) {
        String loggerName = (String)args.get("loggerName");
        String category = (String)args.get("category");
        ILogger logger = Log.getLogger(loggerName);
        logger.stopLogging(category);
    }

    public void addLogger(Hashtable args) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        block3: {
            String loggerName = (String)args.get("loggerName");
            String loggerClass = (String)args.get("loggerClass");
            try {
                Object loggerObj = Creator.newInstance(loggerClass);
                if (loggerObj instanceof ILogger) {
                    Log.addLogger(loggerName, (ILogger)loggerObj);
                }
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block3;
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to add logger. logger name - " + loggerClass, exception);
            }
        }
    }

    public Document deleteLogger(Hashtable args) {
        String loggerName = (String)args.get("loggerName");
        Log.removeLogger(loggerName);
        Document doc = new Document();
        Element root = new Element();
        doc.setRoot(root);
        root.setString("Delete", "true");
        return doc;
    }

    public String startLoggingSession(Hashtable args) {
        String key = new UUID().getKey();
        String loggerName = (String)args.get("loggerName");
        ILogger currentlogger = Log.getLogger(loggerName);
        ConsoleLogger newLogger = new ConsoleLogger(key, this);
        Enumeration cats = Log.getCategories();
        while (cats.hasMoreElements()) {
            String category = (String)cats.nextElement();
            if (!currentlogger.isLogging(category)) continue;
            newLogger.startLogging(category);
        }
        Log.addLogger(CONSOLELOGGER_PREFIX + key, newLogger);
        this.sessions.put(key, new Document(new Element("log")));
        return "sessionId=" + key;
    }

    public boolean stopLoggingSession(Hashtable args) {
        String sessionId = (String)args.get("sessionId");
        sessionId = this.fixSessionId(sessionId);
        this.sessions.remove(sessionId);
        Log.removeLogger(CONSOLELOGGER_PREFIX + sessionId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getLog(Hashtable args) {
        String sessionId = (String)args.get("sessionId");
        sessionId = this.fixSessionId(sessionId);
        Document doc = null;
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            doc = (Document)this.sessions.get(sessionId);
            this.sessions.put(sessionId, new Document(new Element("log")));
        }
        return doc;
    }

    public void enableLogging(Hashtable args) {
        String category = (String)args.get("category");
        String sessionId = (String)args.get("sessionId");
        sessionId = this.fixSessionId(sessionId);
        ILogger logger = Log.getLogger(CONSOLELOGGER_PREFIX + sessionId);
        logger.startLogging(category);
    }

    public void disableLogging(Hashtable args) {
        String category = (String)args.get("category");
        String sessionId = (String)args.get("sessionId");
        sessionId = this.fixSessionId(sessionId);
        ILogger logger = Log.getLogger(CONSOLELOGGER_PREFIX + sessionId);
        logger.stopLogging(category);
    }

    public void setLogFileName(Hashtable args) {
        block3: {
            String loggerName = (String)args.get("loggerName");
            String logFileName = (String)args.get("fileName");
            ILogger logger = Log.getLogger(loggerName);
            try {
                if (logger instanceof WriterLogger) {
                    ((WriterLogger)logger).setWriter(new FileWriter(logFileName));
                }
            }
            catch (IOException exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block3;
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to set log file on the logger " + loggerName, exception);
            }
        }
    }

    public void enableDateTimeLogging(Hashtable args) {
        String loggerName = (String)args.get("loggerName");
        String enable = (String)args.get("enable");
        ILogger logger = Log.getLogger(loggerName);
        if (logger instanceof WriterLogger) {
            ((WriterLogger)logger).logDateTime(!enable.equals("0"));
        }
    }

    public void enableThreadNameLogging(Hashtable args) {
        String loggerName = (String)args.get("loggerName");
        String enable = (String)args.get("enable");
        ILogger logger = Log.getLogger(loggerName);
        if (logger instanceof WriterLogger) {
            ((WriterLogger)logger).logThreadName(!enable.equals("0"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogEntry(String sessionId, String category, String logEntry, Date timeStamp) {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            Document doc = (Document)this.sessions.get(sessionId);
            if (doc == null) {
                return;
            }
            Element root = doc.getRoot();
            root.addElement(category).addText(new CData(logEntry));
            if (root.getElements().size() == 20) {
                root.removeElementAt(1);
            }
        }
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        Element element = new Element("TREE");
        element.addText("Logging");
        element.setAttribute("Name", "Logging");
        element.setAttribute("Function", "showDetails");
        element.setAttribute("TARGET", "_root");
        element.setAttribute("HeaderText", "Logging");
        element.setAttribute("swfURL", this.moduleInfo.getSWFURL());
        element.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
        element.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
        return new Element[]{element};
    }

    public boolean isSessionAware() {
        return false;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    private String fixSessionId(String sessionId) {
        int index = sessionId.indexOf(32);
        if (index > -1) {
            return sessionId.substring(0, index);
        }
        return sessionId;
    }
}

