/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.console.services;

import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.glue.pro.console.services.ConnectionInfoSummary;
import electric.glue.pro.console.services.IConnectionConstants;
import electric.http.HTTPMessage;
import electric.net.channel.IChannel;
import electric.net.channel.IChannelStates;
import electric.net.socket.SocketServer;
import electric.util.XURL;
import electric.util.list.LinkedList;
import electric.util.list.ListNode;
import electric.webserver.WebServer;
import electric.webserver.WebServers;
import electric.xml.Document;
import electric.xml.Element;
import java.util.Hashtable;

public class Connections
implements IConsoleModule,
ITreeViewProducer,
IConnectionConstants,
IConsoleConstants {
    private ConsoleModuleInfo moduleInfo;

    public Document getConnectionInfo(Hashtable args) {
        Document doc = new Document();
        Element root = doc.setRoot("DataUpdate");
        Element connections = root.addElement("Connections");
        Element outbound = connections.addElement("Outbound");
        outbound.setInt("MaxPoolSize", HTTPMessage.getChannelPool().getMaxCacheSize());
        Element inbound = connections.addElement("Inbound");
        inbound.setInt("MaxPoolSize", SocketServer.getMaxKeepAlive());
        boolean addDetails = args.containsKey("details");
        ConnectionInfoSummary summary = this.addSocketInfo(HTTPMessage.getChannels(), addDetails ? outbound.addElement("socketsList") : null);
        this.addSummaryInfo(outbound, summary);
        inbound.setInt("DefaultBacklog", SocketServer.getDefaultBacklog());
        WebServer[] servers = WebServers.getWebServers();
        summary = new ConnectionInfoSummary();
        int i = 0;
        while (i < servers.length) {
            Element serverInfo = null;
            SocketServer socketServer = servers[i].getSocketServer();
            ConnectionInfoSummary serverSummary = this.addSocketInfo(socketServer.getChannels(), serverInfo);
            serverSummary.totalBytesRead += socketServer.getBytesRead();
            serverSummary.totalBytesWritten += socketServer.getBytesWritten();
            summary.totalBytesRead += serverSummary.totalBytesRead;
            summary.totalBytesWritten += serverSummary.totalBytesWritten;
            summary.countByState[0] = summary.countByState[0] + serverSummary.countByState[0];
            summary.countByState[2] = summary.countByState[2] + serverSummary.countByState[2];
            summary.countByState[1] = summary.countByState[1] + serverSummary.countByState[1];
            ++i;
        }
        this.addSummaryInfo(inbound, summary);
        return doc;
    }

    public Document getHostList(Hashtable args) {
        int serverPort = Integer.parseInt((String)args.get("serverPort"));
        WebServer server = WebServers.getWebServer(serverPort);
        SocketServer socketServer = server.getSocketServer();
        LinkedList list = socketServer.getChannels();
        ListNode node = list.getFirst();
        Document doc = new Document();
        Element root = doc.setRoot("Servers");
        Element hosts = root.addElement("Hosts");
        while (node != null) {
            IChannel channel = (IChannel)node.getObject();
            Element host = hosts.addElement("Host");
            host.setText("url", channel.getRemoteXURL().getHost());
            host.setInt("port", channel.getRemoteXURL().getPort());
            node = node.getNext();
        }
        return doc;
    }

    public Document getSocketList(Hashtable args) {
        int serverPort = Integer.parseInt((String)args.get("serverPort"));
        int hostPort = Integer.parseInt((String)args.get("hostPort"));
        WebServer server = WebServers.getWebServer(serverPort);
        SocketServer socketServer = server.getSocketServer();
        LinkedList list = socketServer.getChannels();
        ListNode node = list.getFirst();
        Document doc = new Document();
        Element root = doc.setRoot("Servers");
        Element sockets = root.addElement("Sockets");
        while (node != null) {
            IChannel channel = (IChannel)node.getObject();
            if (channel.getRemoteXURL().getPort() == hostPort) {
                Element socket = sockets.addElement("Socket");
                socket.setText("url", channel.getRemoteXURL().getHost());
                socket.setInt("port", channel.getRemoteXURL().getPort());
                socket.setLong("read", channel.getBytesRead());
                socket.setLong("write", channel.getBytesWritten());
                socket.setText("state", IChannelStates.STATES[channel.getState()]);
            }
            node = node.getNext();
        }
        return doc;
    }

    public Document getServers() {
        Document doc = new Document();
        Element root = doc.setRoot("Connections");
        Element serversNode = root.addElement("Servers");
        WebServer[] servers = WebServers.getWebServers();
        int i = 0;
        while (i < servers.length) {
            XURL xurl = servers[i].getXURL();
            int port = xurl.getPort();
            Element server = serversNode.addElement("server");
            server.setText("url", xurl.toString());
            server.setInt("port", port);
            ++i;
        }
        return doc;
    }

    public Document getServerInformation(Hashtable args) {
        int serverPort = Integer.parseInt((String)args.get("serverPort"));
        WebServer server = WebServers.getWebServer(serverPort);
        SocketServer socketServer = server.getSocketServer();
        LinkedList list = socketServer.getChannels();
        ListNode node = list.getFirst();
        Document doc = new Document();
        Element root = doc.setRoot("Server");
        Element statitics = root.addElement("Statistics");
        Element dummyNode = new Element();
        ConnectionInfoSummary serverSummary = this.addSocketInfo(socketServer.getChannels(), dummyNode);
        statitics.setLong("read", serverSummary.totalBytesRead);
        statitics.setLong("write", serverSummary.totalBytesWritten);
        statitics.setInt("active", serverSummary.countByState[0]);
        statitics.setInt("idle", serverSummary.countByState[2]);
        statitics.setInt("pending", serverSummary.countByState[1]);
        return doc;
    }

    public void setDefaultBacklog(Hashtable args) {
        try {
            SocketServer.setDefaultBacklog(Integer.parseInt((String)args.get("backlog")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setServerPoolSize(Hashtable args) {
        try {
            SocketServer.setMaxKeepAlive(Integer.parseInt((String)args.get("poolSize")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setClientPoolProps(Hashtable args) {
        HTTPMessage.setMaxCacheSize(Integer.parseInt((String)args.get("poolSize")));
    }

    private void addSummaryInfo(Element element, ConnectionInfoSummary summary) {
        element.setInt("TotalActive", summary.countByState[0]);
        element.setInt("TotalIdle", summary.countByState[2]);
        element.setString("TotalBytesSent", summary.totalBytesWritten / 1024L + "K");
        element.setString("TotalBytesReceived", summary.totalBytesRead / 1024L + "K");
    }

    private ConnectionInfoSummary addSocketInfo(LinkedList list, Element element) {
        ListNode node = list.getFirst();
        ConnectionInfoSummary summary = new ConnectionInfoSummary();
        while (node != null) {
            IChannel channel = (IChannel)node.getObject();
            summary.totalBytesRead += channel.getBytesRead();
            summary.totalBytesWritten += channel.getBytesWritten();
            int n = channel.getState();
            summary.countByState[n] = summary.countByState[n] + 1;
            if (element != null) {
                Element socketNode = element.addElement("socket");
                socketNode.setText("url", channel.getRemoteXURL().getHost());
                socketNode.setInt("port", channel.getRemoteXURL().getPort());
                socketNode.setLong("read", channel.getBytesRead());
                socketNode.setLong("write", channel.getBytesWritten());
                socketNode.setText("state", IChannelStates.STATES[channel.getState()]);
            }
            node = node.getNext();
        }
        return summary;
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        Element element1 = new Element("TREE");
        element1.addText("InboundHTTP");
        element1.setAttribute("Name", "Inbound HTTP");
        element1.setAttribute("Function", "showDetails");
        element1.setAttribute("Path", "/Inbound HTTP");
        element1.setAttribute("HeaderText", "Inbound HTTP");
        element1.setAttribute("TARGET", "_root");
        element1.setAttribute("swfURL", this.moduleInfo.getSWFURL());
        element1.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
        element1.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
        Element element2 = new Element("TREE");
        element2.addText("OutboundHTTP");
        element2.setAttribute("Name", "Outbound HTTP");
        element2.setAttribute("Function", "showDetails");
        element2.setAttribute("Path", "/Outbound HTTP");
        element2.setAttribute("HeaderText", "Outbound HTTP");
        element2.setAttribute("TARGET", "_root");
        element2.setAttribute("swfURL", this.moduleInfo.getSWFURL());
        element2.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
        element2.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
        return new Element[]{element1, element2};
    }

    public boolean isSessionAware() {
        return false;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }
}

