/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.console.handlers;

import electric.console.handlers.IConsoleHandler;
import electric.glue.pro.console.handlers.IHandlersConstants;
import electric.util.log.ILogger;
import electric.util.log.Log;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoggingHandler
implements IConsoleHandler,
IHandlersConstants {
    public boolean handle(String pathInfo, Hashtable queryParams, ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (queryParams.get("logwindow") == null) {
            return false;
        }
        Object servicePath = queryParams.get("servicepath");
        Object serviceURL = queryParams.get("serviceURL");
        Object windowHeader = queryParams.get("header");
        Object loggerName = queryParams.get("loggerName");
        this.returnLoggerWindow(response, servicePath, serviceURL, windowHeader, loggerName);
        return true;
    }

    private void returnLoggerWindow(HttpServletResponse response, Object servicePath, Object serviceURL, Object windowHeader, Object loggerId) throws IOException {
        servicePath = servicePath == null ? "" : ((Object[])servicePath)[0];
        serviceURL = ((Object[])serviceURL)[0];
        String loggerName = ((Object[])loggerId)[0].toString();
        String catsOn = this.getLogCategories(loggerName, true);
        String catsOff = this.getLogCategories(loggerName, false);
        String flashVars = "servicePath=" + servicePath + "&serviceURL=" + serviceURL + "&categoriesOn=" + catsOn + "&categoriesOff=" + catsOff + "&loggerName=" + loggerName;
        response.getWriter().write("<HTML>\n<HEAD>\n<TITLE>Logging Window - " + ((Object[])windowHeader)[0] + "</TITLE>\n" + "<script language=\"JavaScript\">\n" + "//<!--\n" + "var closeMethodURL;\n" + "function setSessionId( closeMethodURL )\n" + "{\n" + " this.closeMethodURL = closeMethodURL;\n" + "}\n" + "\n" + "function goForm ()\n" + "{\n" + "    window.location=this.closeMethodURL;\n" + "    window.close();\n" + "}\n" + "//-->\n" + "</script> \n" + "</HEAD>\n" + "<BODY bgcolor=\"#b4b39a\" leftmargin=\"0\" topmargin=\"0\" marginwidth=\"0\" marginheight=\"0\" onUnload=\"goForm()\">\n" + "<form action=\"\" name=\"formCloseWindow\" method=\"post\"></form>\n" + "<OBJECT classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0\"\n" + " WIDTH=\"540\" HEIGHT=\"480\" id=\"logging-window\" ALIGN=\"\">\n" + " <PARAM NAME=movie VALUE=\"console?resource=console/glue/logging/logging-monitor.swf\">\n" + " <PARAM NAME=FlashVars VALUE=" + flashVars + ">\n" + " <PARAM NAME=quality VALUE=high>\n" + " <PARAM NAME=scale VALUE=exactfit>\n" + " <PARAM NAME=bgcolor VALUE=#b4b39a> \n" + "  <EMBED" + " \tsrc=\"console?resource=console/glue/logging/logging-monitor.swf\"" + " \tFlashVars=" + flashVars + " \tquality=high scale=exactfit" + " \tbgcolor=#b4b39a" + " \tWIDTH=540" + " \tHEIGHT=480" + " \tNAME=\"logging-window\"" + " \tALIGN=\"\"" + "\tTYPE=application/x-shockwave-flash" + "\tPLUGINSPAGE=\"http://www.macromedia.com/go/getflashplayer\">" + " </EMBED></OBJECT>\n" + "</BODY>\n" + "</HTML>\n");
    }

    private String getLogCategories(String loggerName, boolean onState) {
        ILogger logger = Log.getLogger(loggerName);
        String loggers = "";
        Enumeration categories = Log.getCategories();
        while (categories.hasMoreElements()) {
            String category = URLEncoder.encode((String)categories.nextElement());
            if (onState && logger.isLogging(category)) {
                loggers = loggers.equals("") ? "'" + category + "'" : loggers + ",'" + category + "'";
                continue;
            }
            if (onState || logger.isLogging(category)) continue;
            String string = loggers = loggers.equals("") ? "'" + category + "'" : loggers + ",'" + category + "'";
        }
        return loggers;
    }
}

