/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.config;

import electric.glue.pro.config.IConfigConstants;
import electric.soap.security.signature.xml.crypto.ISignatureAlgorithm;
import electric.soap.security.signature.xml.crypto.SignatureAlgorithms;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.xml.Element;
import electric.xml.Elements;

public class XMLSignatureConfig
implements IConfig,
ILoggingConstants,
IConfigConstants {
    public void config(Element config) throws Throwable {
        Element xmlSignatureElement = config.getElement("xmlSignature");
        if (xmlSignatureElement == null) {
            return;
        }
        this.configSignatureAlgorithms(xmlSignatureElement);
    }

    private void configSignatureAlgorithms(Element config) {
        Elements algorithms = config.getElements("signatureAlgorithm");
        while (algorithms.hasMoreElements()) {
            Element algorithmElement = algorithms.next();
            String algorithmClassName = algorithmElement.getString("class");
            String algorithmId = algorithmElement.getString("id");
            if (algorithmClassName == null || algorithmClassName.length() == 0) continue;
            try {
                Class algorithmClass = ClassLoaders.loadClass(algorithmClassName);
                ISignatureAlgorithm algorithm = (ISignatureAlgorithm)algorithmClass.newInstance();
                SignatureAlgorithms.registerSignatureAlgorithm(algorithmId, algorithm);
            }
            catch (Throwable exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) continue;
                Log.log(ILoggingConstants.ERROR_EVENT, (Object)("could not load signature algorithm " + exception.toString()));
            }
        }
    }
}

