/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.enterprise.console.services;

import electric.application.web.servlets.ServletDescriptor;
import electric.cluster.IClusteredApplication;
import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.glue.context.ProxyContext;
import electric.glue.enterprise.console.services.IClusterServletsConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.util.Context;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Document;
import electric.xml.Element;
import java.util.Enumeration;
import java.util.Hashtable;

public class Servlets
implements IConsoleModule,
IConsoleConstants,
IClusterServletsConstants,
ILoggingConstants {
    static /* synthetic */ Class class$electric$cluster$IClusteredApplication;

    public Document getServletList(Hashtable args) {
        Document doc;
        block3: {
            String appName = (String)args.get("applicationName");
            doc = new Document();
            Element servlets = doc.setRoot("Servlets");
            Element listNode = servlets.addElement("List");
            try {
                IClusteredApplication application = this.getApplication(appName);
                String[] servletNames = application.getServletNames();
                int i = 0;
                while (i < servletNames.length) {
                    listNode.addElement("Servlet").setString(servletNames[i]);
                    ++i;
                }
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block3;
                Log.log(ILoggingConstants.ERROR_EVENT, "cannot obtain list of servlets for application " + appName, exception);
            }
        }
        return doc;
    }

    public Document getServletDetails(Hashtable args) {
        Document doc;
        block4: {
            String clusterName = (String)args.get("clusterName");
            String appName = (String)args.get("applicationName");
            String servletName = (String)args.get("servletName");
            doc = new Document();
            Element servlet = doc.setRoot("Servlet");
            servlet.setString("Name", servletName);
            try {
                IClusteredApplication application = this.getApplication(appName);
                ServletDescriptor descriptor = application.getServletDescriptor(servletName);
                servlet.setString("Class", descriptor.servletClassName);
                Element urlPatterns = servlet.addElement("URLPatterns");
                int i = 0;
                while (i < descriptor.urlPatterns.length) {
                    Element urlPattern = new Element("URLPattern");
                    urlPattern.setString(descriptor.urlPatterns[i]);
                    urlPatterns.addElement(urlPattern);
                    ++i;
                }
                servlet.setInt("LoadStartup", descriptor.loadOnStartup);
                Element parametersNode = servlet.addElement("Parameters");
                Enumeration enumeration = descriptor.initParameters.keys();
                while (enumeration.hasMoreElements()) {
                    Element parameter = new Element("Parameter");
                    String name = (String)enumeration.nextElement();
                    parameter.setString("Name", name);
                    parameter.setString("Value", (String)descriptor.initParameters.get(name));
                    parametersNode.addElement(parameter);
                }
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block4;
                Log.log(ILoggingConstants.ERROR_EVENT, "cannot obtain servlet details for servlet " + servletName, exception);
            }
        }
        return doc;
    }

    private IClusteredApplication getApplication(String appName) throws RegistryException {
        ProxyContext context = new ProxyContext();
        context.setProperty("service.appName", appName);
        return (IClusteredApplication)Registry.bind(class$electric$cluster$IClusteredApplication == null ? (class$electric$cluster$IClusteredApplication = Servlets.class$("electric.cluster.IClusteredApplication")) : class$electric$cluster$IClusteredApplication, (Context)context);
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

