/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.enterprise.console.services;

import electric.cluster.IClusteredApplication;
import electric.console.IConsoleConstants;
import electric.console.services.ConsoleFacade;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.ServiceInfo;
import electric.fabric.services.ServiceManager;
import electric.fabric.services.ServiceManagerException;
import electric.glue.context.ProxyContext;
import electric.glue.enterprise.console.services.IClustersConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.util.Context;
import electric.util.string.Strings;
import electric.wsdl.util.SignatureGenerator;
import electric.xml.Element;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class Clusters
implements IConsoleModule,
ITreeViewProducer,
IFabricConstants,
IClustersConstants,
IConsoleConstants {
    private static String applicationServiceSignature;
    private HashMap sessionListeners = new HashMap();
    private ConsoleModuleInfo moduleInfo;
    static /* synthetic */ Class class$electric$cluster$IClusteredApplication;

    public Clusters() {
        applicationServiceSignature = SignatureGenerator.getSignature(class$electric$cluster$IClusteredApplication == null ? (class$electric$cluster$IClusteredApplication = Clusters.class$("electric.cluster.IClusteredApplication")) : class$electric$cluster$IClusteredApplication);
    }

    private Vector getApplications() {
        Vector<ServiceInfo> apps = new Vector<ServiceInfo>();
        try {
            String query = "service.signature=" + applicationServiceSignature + "&" + "service.online" + "=true";
            ServiceManager serviceManager = Fabric.getServiceManager();
            if (serviceManager != null) {
                ServiceInfo[] matches = serviceManager.findServicesForPath(query);
                apps.addAll(Arrays.asList(matches));
            }
        }
        catch (ServiceManagerException exception) {
            exception.printStackTrace();
        }
        return apps;
    }

    private void addCluster(Element clusterElement, Vector clusterApps) {
        String appName;
        HashMap<String, Integer> appCounter = new HashMap<String, Integer>();
        HashMap<String, Element> appsMap = new HashMap<String, Element>();
        int maxCounter = 0;
        Enumeration enumeration = clusterApps.elements();
        while (enumeration.hasMoreElements()) {
            ServiceInfo applicationServiceInfo = (ServiceInfo)enumeration.nextElement();
            appName = applicationServiceInfo.getMetadata("appName");
            if (appCounter.containsKey(appName)) {
                int counter = (Integer)appCounter.get(appName) + 1;
                maxCounter = Math.max(counter, maxCounter);
                appCounter.put(appName, new Integer(counter));
                continue;
            }
            appCounter.put(appName, new Integer(1));
            Element appElement = this.addApplication(appName);
            clusterElement.addElement(appElement);
            appsMap.put(appName, appElement);
        }
        Iterator iterator = appCounter.keySet().iterator();
        while (iterator.hasNext()) {
            appName = (String)iterator.next();
            int appCount = (Integer)appCounter.get(appName);
            if (appCount >= maxCounter) continue;
            clusterElement.removeChild((Element)appsMap.get(appName));
        }
    }

    private Element addApplication(String name) {
        Element element = new Element("TREE");
        this.setAttributes(element, name, "Application");
        Element serviceElement = new Element("TREE");
        this.setAttributes(serviceElement, "Services", "ClusterServices");
        serviceElement.setAttribute("ModuleFunction", "showOverview");
        serviceElement.setAttribute("ApplicationName", name);
        this.setServices(serviceElement, name);
        Element servletElement = new Element("TREE");
        this.setAttributes(servletElement, "Servlets", "ClusterServlets");
        servletElement.setAttribute("ApplicationName", name);
        element.addElement(serviceElement);
        element.addElement(servletElement);
        return element;
    }

    private TreeSet setServices(Element element, String applicationName) {
        Element registryNode = element.addElement("Registry");
        this.setAttributes(registryNode, "Registry", "ClusterServices");
        registryNode.setAttribute("ModuleFunction", "showFolders");
        HashMap<String, Element> folders = new HashMap<String, Element>();
        folders.put("", registryNode);
        TreeSet services = this.getServicesTree(applicationName);
        Iterator iterator = services.iterator();
        while (iterator.hasNext()) {
            String servicePath = ((String)iterator.next()).replace('\\', '/');
            String endpoint = Strings.getEndpoint(servicePath);
            String urn = Strings.getURN(servicePath);
            Element folder = this.getFolderElement(folders, endpoint);
            Element serviceNode = folder.addElement(urn);
            this.setAttributes(serviceNode, urn, "ClusterServices");
            serviceNode.setAttribute("customIcon", "ftree_icon_ws");
            serviceNode.setAttribute("ModuleFunction", "showService");
        }
        return services;
    }

    private TreeSet getServicesTree(String appName) {
        ProxyContext context = new ProxyContext();
        context.setProperty("service.appName", appName);
        TreeSet<String> services = new TreeSet<String>();
        try {
            IClusteredApplication application = (IClusteredApplication)Registry.bind(class$electric$cluster$IClusteredApplication == null ? (class$electric$cluster$IClusteredApplication = Clusters.class$("electric.cluster.IClusteredApplication")) : class$electric$cluster$IClusteredApplication, (Context)context);
            String[] endpoints = application.getServicePaths();
            services.addAll(Arrays.asList(endpoints));
        }
        catch (RegistryException exception) {}
        return services;
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        if (!this.sessionListeners.containsKey(sessionID)) {
            Vector apps = this.getApplications();
            Element element = new Element("TREE");
            element.addText("Cluster");
            element.setAttribute("Name", "Cluster");
            element.setAttribute("Function", "showDetails");
            element.setAttribute("TARGET", "_root");
            element.setAttribute("swfURL", this.moduleInfo.getSWFURL());
            element.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
            element.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
            this.addCluster(element, apps);
            if (element.getElements().size() == 0) {
                return null;
            }
            this.sessionListeners.put(sessionID, apps);
            return new Element[]{element};
        }
        return null;
    }

    private void setAttributes(Element element, String name, String consoleModuleName) {
        ConsoleModuleInfo moduleInfo = ConsoleFacade.getConsoleModuleInfo(consoleModuleName);
        element.setAttribute("Name", name);
        element.setAttribute("Function", "showDetails");
        element.setAttribute("TARGET", "_root");
        element.setAttribute("swfURL", moduleInfo.getSWFURL());
        element.setAttribute("helpfileURL", moduleInfo.getHelpFileURL());
        element.setAttribute("serviceURL", moduleInfo.getServiceURL());
    }

    private Element getFolderElement(HashMap folders, String folderPath) {
        Element folder = (Element)folders.get(folderPath);
        if (folder == null) {
            String folderName = Strings.getURN(folderPath);
            folder = new Element(folderName);
            this.setAttributes(folder, folderName, "ClusterServices");
            folder.setAttribute("ModuleFunction", "showFolders");
            folders.put(folderPath, folder);
            String folderParent = Strings.getEndpoint(folderPath);
            Element parentElement = this.getFolderElement(folders, folderParent);
            parentElement.addElement(folder);
        }
        return folder;
    }

    public boolean isSessionAware() {
        return true;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

