/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.enterprise.config;

import electric.cluster.registry.ClusterRegistry;
import electric.fabric.Fabric;
import electric.glue.IGLUELoggingConstants;
import electric.glue.enterprise.config.AppConfig;
import electric.glue.enterprise.config.IConfigConstants;
import electric.glue.enterprise.config.WebServerConfig;
import electric.glue.pro.config.ConsoleConfig;
import electric.registry.Registry;
import electric.util.Context;
import electric.util.log.Log;
import electric.util.log.WriterLogger;
import electric.util.product.ProductConfig;
import electric.util.string.Strings;
import electric.xml.Element;

public class Config
extends ProductConfig
implements IConfigConstants {
    private static final int ID = 5;
    private static final int MAJOR = 5;
    private static final int MINOR = 0;
    private static final int PATCH = 0;

    public Config() {
        super("Glue Enterprise", 5, 5, 0, 0);
    }

    public void configure(Element config) throws Throwable {
    }

    public void configureAsServer(Element config, Object application) throws Throwable {
        boolean connectorMode;
        ConsoleConfig.addConsoleModule("Glue Enterprise");
        if (Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) {
            WriterLogger logger = (WriterLogger)Log.getLogger("default");
            logger.setLogDateTimeFormat(null);
            Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)"configuring glue enterprise");
        }
        if (connectorMode = Strings.getBoolean(Context.getSystemProperty("glue.connector"), false)) {
            if (Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)"starting dispatcher in connector mode");
            }
            return;
        }
        Fabric.join();
        boolean startChildVM = Strings.getBoolean(Context.getSystemProperty("glue.childvm"), false);
        if (!startChildVM) {
            new WebServerConfig().config(config.getRoot());
        }
        Registry.addRegistry("clusterRegistry", new ClusterRegistry(), 0.0f);
        if (!startChildVM) {
            new AppConfig().config(config.getRoot());
        }
    }

    public void executeLicenseConstraints() {
    }
}

