/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.context;

import electric.glue.IGLUEContextConstants;
import electric.security.IGuard;
import electric.service.IActivationConstants;
import electric.service.descriptor.MethodDescriptor;
import electric.soap.ISOAPInterceptor;
import electric.soap.security.WSSContext;
import electric.soap.wsdl.personality.ISOAPPersonality;
import electric.soap.wsdl.personality.dotnet.NETSOAPPersonality;
import electric.util.Context;
import electric.util.mime.IDataHandler;
import electric.wsdl.personality.IWSDLPersonality;
import electric.wsdl.personality.net.NETWSDLPersonality;
import java.util.Enumeration;

public class ServiceContext
extends Context
implements IGLUEContextConstants,
IActivationConstants {
    public void setActivation(String mode) {
        this.setProperty("activation", mode);
    }

    public void setRequestActivation() {
        this.setActivation("request");
    }

    public boolean isRequestActivation() {
        return "request".equals(this.getActivation());
    }

    public void setApplicationActivation() {
        this.setActivation("application");
    }

    public boolean isApplicationActivation() {
        return "application".equals(this.getActivation());
    }

    public void setSessionActivation() {
        this.setActivation("session");
    }

    public boolean isSessionActivation() {
        return "session".equals(this.getActivation());
    }

    public String getActivation() {
        return this.getStringProperty("activation");
    }

    public void setClassName(String className) {
        this.setProperty("className", className);
    }

    public String getClassName() {
        return this.getStringProperty("className");
    }

    public void setDataDirectory(String directory) {
        this.setProperty("dataDirectory", directory);
    }

    public String getDataDirectory() {
        return this.getStringProperty("dataDirectory");
    }

    public void setDataHandler(String contentType, IDataHandler handler) {
        this.setProperty(contentType + " " + "dataHandler", handler);
    }

    public void setDescription(String description) {
        this.setProperty("description", description);
    }

    public String getDescription() {
        return this.getStringProperty("description");
    }

    public void addEndpoint(String url) {
        this.addProperty("endpoint", url);
    }

    public Enumeration getEndpoints() {
        return this.getProperties("endpoint");
    }

    public void addInterface(String interfaceName) {
        this.addProperty("interface", interfaceName);
    }

    public Enumeration getInterfaces() {
        return this.getProperties("interface");
    }

    public void setPublish(boolean flag) {
        this.setProperty("publish", new Boolean(flag).toString());
    }

    public boolean isPublish() {
        return this.getBooleanProperty("publish", false);
    }

    public void addGuard(IGuard guard) {
        this.addProperty("guard", guard);
    }

    public Enumeration getGuards() {
        return this.getProperties("guard");
    }

    public void addInboundSoapRequestInterceptor(ISOAPInterceptor interceptor) {
        this.addProperty("inboundSoapRequestInterceptor", interceptor);
    }

    public Enumeration getInboundSoapRequestInterceptors() {
        return this.getProperties("inboundSoapRequestInterceptor");
    }

    public void addOutboundSoapRequestInterceptor(ISOAPInterceptor interceptor) {
        this.addProperty("outboundSoapRequestInterceptor", interceptor);
    }

    public Enumeration getOutboundSoapRequestInterceptors() {
        return this.getProperties("outboundSoapRequestInterceptor");
    }

    public void setSOAPAction(String action) {
        this.setProperty("soapAction", action);
    }

    public String getSOAPAction() {
        return this.getStringProperty("soapAction");
    }

    public void setStyle(String style) {
        this.setProperty("style", style);
    }

    public void setDocumentStyle() {
        this.setStyle("document");
    }

    public void setRPCStyle() {
        this.setStyle("rpc");
    }

    public String getStyle() {
        return this.getStringProperty("style");
    }

    public String getUse() {
        return this.getStringProperty("use");
    }

    public void setUse(String use) {
        this.setProperty("use", use);
    }

    public void setLiteralUse() {
        this.setUse("literal");
    }

    public void setEncodedUse() {
        this.setUse("encoded");
    }

    public void setTargetNamespace(String namespace) {
        this.setProperty("targetNamespace", namespace);
    }

    public String getTargetNamespace() {
        return this.getStringProperty("targetNamespace");
    }

    public void setWSDLPersonality(IWSDLPersonality personality) {
        this.addProperty("wsdlPersonality", personality);
    }

    public IWSDLPersonality getWSDLPersonality() {
        return (IWSDLPersonality)this.getProperty("wsdlPersonality");
    }

    public void setSOAPPersonality(ISOAPPersonality personality) {
        this.addProperty("soapPersonality", personality);
    }

    public ISOAPPersonality getSOAPPersonality() {
        return (ISOAPPersonality)this.getProperty("soapPersonality");
    }

    public void setNETEmulation() {
        this.setSOAPPersonality(new NETSOAPPersonality());
        this.setWSDLPersonality(new NETWSDLPersonality());
    }

    public void addXMLInclude(String className) {
        this.addProperty("xmlInclude", className);
    }

    public Enumeration getXMLIncludes() {
        return this.getProperties("xmlInclude");
    }

    public void setWSSContext(WSSContext context) {
        this.setProperty("wssContext", context);
    }

    public WSSContext getWSSContext() {
        return (WSSContext)this.getProperty("wssContext");
    }

    public void setAttachmentStyle(String style) {
        this.setProperty("attachmentStyle", style);
    }

    public void setMIMEAttachmentStyle() {
        this.setAttachmentStyle("mime");
    }

    public void setDIMEAttachmentStyle() {
        this.setAttachmentStyle("dime");
    }

    public String getAttachmentStyle() {
        return this.getStringProperty("attachmentStyle");
    }

    public void addMethodDescriptor(MethodDescriptor descriptor) {
        this.addProperty("method", descriptor);
    }

    public Enumeration getMethodDescriptors() {
        return this.getProperties("method");
    }

    public void publishMethod(String signature) {
        this.addProperty("method", new MethodDescriptor(signature));
    }
}

