/*
 * Decompiled with CFR 0.152.
 */
package electric.getpost.wsdl;

import electric.getpost.wsdl.HTTPBinding;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Operation;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.io.schema.SchemaException;
import java.lang.reflect.Method;

public final class HTTPOperation
implements IWSDLConstants {
    private HTTPBinding binding;
    private String name;
    private String location;
    private Operation operation;

    public HTTPOperation(HTTPBinding binding, Element httpOperation) throws WSDLException {
        this.binding = binding;
        this.name = httpOperation.getAttributeValue("name");
        if (this.name == null) {
            throw new WSDLException("HTTP <operation> is missing name attribute");
        }
        this.operation = this.getOperation(this.name);
        this.location = httpOperation.getElement("operation").getAttributeValue("location");
        Element inputElement = httpOperation.getElement("input");
        Element outputElement = httpOperation.getElement("output");
    }

    public HTTPOperation(HTTPBinding binding, Method method, int index, String suffix) throws WSDLException, SchemaException {
        this.binding = binding;
        this.operation = new Operation(binding.getWSDL(), binding.getNamespace(), method, index, suffix, "Body", true);
        this.name = this.operation.getName();
        this.location = "/" + this.operation.getName();
    }

    public Operation getOperation() {
        return this.operation;
    }

    private Operation getOperation(String name) {
        Operation[] operations = this.binding.getPortType().getOperations();
        int i = 0;
        while (i < operations.length) {
            if (operations[i].getName().equals(name) && this.binding.getHTTPOperation(operations[i]) == null) {
                return operations[i];
            }
            ++i;
        }
        return null;
    }

    public void writeWSDL(Element binding) {
        Element inputBody;
        String wsdlPrefix = binding.getNamespacePrefix("http://schemas.xmlsoap.org/wsdl/");
        Element operationElement = binding.addElement(wsdlPrefix, "operation");
        operationElement.setAttribute("name", this.name);
        Element httpOperation = operationElement.addElement("http", "operation");
        httpOperation.setAttribute("location", this.location);
        Element input = operationElement.addElement(wsdlPrefix, "input");
        input.setAttribute("name", this.operation.getInput().getName());
        if (this.binding.isGet()) {
            inputBody = input.addElement("http", "urlEncoded");
        } else {
            inputBody = input.addElement("mime", "content");
            inputBody.setAttribute("type", "application/x-www-form-urlencoded");
        }
        Element output = operationElement.addElement(wsdlPrefix, "output");
        output.setAttribute("name", this.operation.getOutput().getName());
        Element outputBody = output.addElement("mime", "mimeXml");
        outputBody.setAttribute("part", "Body");
    }
}

