/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services.registry;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.ServiceInfo;
import electric.registry.IRegistry;
import electric.registry.IRegistryListener;
import electric.registry.Registry;
import electric.registry.directory.DirectoryRegistry;
import electric.service.IService;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import java.util.Enumeration;
import java.util.Hashtable;

public final class FabricRegistryListener
implements IRegistryListener,
IFabricConstants {
    private String[] autoPublishPaths = new String[0];
    private Hashtable pathToEndpoint = new Hashtable();
    static /* synthetic */ Class class$electric$soap$wsdl$SOAPPort;

    public FabricRegistryListener() {
        Registry.addListener("fabric-listener", this);
    }

    public void autoPublish(String path) {
        this.autoPublishPaths = (String[])ArrayUtil.addElement(this.autoPublishPaths, path);
    }

    public boolean isAutoPublish(String path) {
        int i = 0;
        while (i < this.autoPublishPaths.length) {
            if (path.startsWith(this.autoPublishPaths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void published(IRegistry registry, String path, Object object, Context context2) {
        if (!(registry instanceof DirectoryRegistry) && !(object instanceof IService)) {
            return;
        }
        IService service = (IService)object;
        Context context = service.getContext();
        if (!this.isAutoPublish(path) && !context.getBooleanProperty("share", false)) {
            return;
        }
        String wsdlURL = service.getWSDL().getPath();
        XURL endpoint = service.getWSDL().getEndpoints(class$electric$soap$wsdl$SOAPPort == null ? (class$electric$soap$wsdl$SOAPPort = FabricRegistryListener.class$("electric.soap.wsdl.SOAPPort")) : class$electric$soap$wsdl$SOAPPort)[0];
        this.pathToEndpoint.put(path, endpoint.toString());
        try {
            ServiceInfo serviceInfo = new ServiceInfo(wsdlURL);
            serviceInfo.setDescription(context.getStringProperty("description"));
            this.addMetadata(serviceInfo, context);
            serviceInfo.addMetadata("inFabricServer", "true");
            Fabric.getServiceManager().publishUsingInfo(serviceInfo);
        }
        catch (Exception exception) {}
    }

    private void addMetadata(ServiceInfo serviceInfo, Context context) {
        Enumeration names = context.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("service.")) continue;
            String key = name.substring("service.".length());
            Enumeration values = context.getProperties(name);
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                serviceInfo.addMetadata(key, value.toString());
            }
        }
    }

    public void unpublished(IRegistry registry, String path, Object object) {
        String endpoint = (String)this.pathToEndpoint.get(path);
        if (endpoint == null) {
            return;
        }
        try {
            Fabric.getServiceManager().unpublishUsingEndpoint(endpoint);
        }
        catch (Exception exception) {}
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

