/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services.registry;

import electric.fabric.IFabricConstants;
import electric.proxy.IReference;
import electric.registry.IRegistry;
import electric.registry.RegistryException;
import electric.soap.java.reference.JavaToSOAP;
import electric.soap.references.ISOAPReference;
import electric.soap.references.SOAPReferenceFactories;
import electric.util.Context;
import electric.util.ExceptionUtil;
import electric.util.XURL;
import electric.util.http.HTTPUtil;
import electric.util.license.LicensingException;
import electric.wsdl.util.SignatureGenerator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

public final class FabricRegistry
implements IRegistry,
IFabricConstants {
    private Hashtable interfaceToStyle = new Hashtable();
    private Hashtable interfaceToReference = new Hashtable();
    private HashSet allowedInterfaces = new HashSet();

    public FabricRegistry(String[] allowedInterfaceNames) {
        this.checkCallingClass();
        if (allowedInterfaceNames != null) {
            int i = 0;
            while (i < allowedInterfaceNames.length) {
                this.allowedInterfaces.add(allowedInterfaceNames[i]);
                ++i;
            }
        }
    }

    public IReference bind(String path, Class[] interfaces, Context proxyContext) throws RegistryException {
        if (!path.startsWith("fabric://")) {
            return null;
        }
        if (interfaces != null && this.allowedInterfaces.size() > 0) {
            int i = 0;
            while (i < interfaces.length) {
                if (!this.allowedInterfaces.contains(interfaces[i].getName())) {
                    this.throwLicenseException();
                }
                ++i;
            }
        }
        try {
            IReference reference;
            if (path.indexOf("service.wsdl") == -1 && interfaces != null && interfaces.length >= 1 && (reference = this.getReference(interfaces[0])) != null) {
                return reference;
            }
            if (path.indexOf("service.signature") == -1) {
                path = this.getPathWithSignature(path, interfaces, proxyContext);
            }
            path = "?glue&" + path.substring("fabric://".length());
            ISOAPReference soapReference = SOAPReferenceFactories.newSOAPReference(new XURL(path = this.addMetadata(path, proxyContext)), null, proxyContext);
            if (soapReference == null) {
                throw new RegistryException("could not bind to " + path);
            }
            return new JavaToSOAP(soapReference.getEndpoint(), soapReference, proxyContext);
        }
        catch (RegistryException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new RegistryException(exception);
        }
    }

    private String addQualityOfService(String path, Context proxyContext) {
        int i = 0;
        while (i < IFabricConstants.QUALITIES_OF_SERVICE.length) {
            boolean add = proxyContext.getBooleanProperty(IFabricConstants.QUALITIES_OF_SERVICE[i], false);
            if (add) {
                path = HTTPUtil.addParameter(path, IFabricConstants.QUALITIES_OF_SERVICE[i]);
            }
            ++i;
        }
        return path;
    }

    private String addMetadata(String path, Context proxyContext) {
        Enumeration names = proxyContext.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("service.")) continue;
            Enumeration values = proxyContext.getProperties(name);
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                path = HTTPUtil.addParameter(path, name, value.toString());
            }
        }
        return path;
    }

    private String getPathWithSignature(String path, Class[] interfaces, Context proxyContext) throws RegistryException {
        String style;
        if (interfaces != null && interfaces.length >= 1 && (style = this.getStyle(interfaces[0])) != null) {
            proxyContext.setProperty("style", style);
        }
        if (!path.endsWith("//")) {
            path = path + "&";
        }
        return path + "service.signature" + "=" + this.getSignature(interfaces, proxyContext);
    }

    private String getSignature(Class[] interfaces, Context context) throws RegistryException {
        try {
            return SignatureGenerator.getSignature(interfaces, context);
        }
        catch (Exception exception) {
            throw new RegistryException(exception);
        }
    }

    public void mapInterfaceToStyle(Class type, String style) {
        this.interfaceToStyle.put(type, style);
    }

    public String getStyle(Class type) {
        return (String)this.interfaceToStyle.get(type);
    }

    public void mapInterfaceToReference(Class type, IReference reference) {
        this.interfaceToReference.put(type, reference);
    }

    public IReference getReference(Class type) {
        return (IReference)this.interfaceToReference.get(type);
    }

    public boolean publish(String path, Object object, Context context) throws RegistryException {
        return false;
    }

    public boolean unpublish(String path) throws RegistryException {
        return false;
    }

    private void checkCallingClass() {
        int fabricPluginPos = ExceptionUtil.getStackTracePos("electric.fabric.config.FabricPlugin");
        int thisClassPos = ExceptionUtil.getStackTracePos(this.getClass().getName());
        if (fabricPluginPos == -1 || thisClassPos - fabricPluginPos > 1) {
            this.throwLicenseException();
        }
    }

    private void throwLicenseException() {
        throw new LicensingException("Glue Fabric license is reserved only for the internal use.");
    }
}

