/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services.reference.constraint;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.ServicePath;
import electric.soap.references.ISOAPReference;
import electric.soap.references.ISOAPReferenceFactory;
import electric.soap.references.SOAPReferenceFactories;
import electric.util.Context;
import electric.util.XURL;
import electric.util.http.HTTPUtil;
import electric.wsdl.WSDL;
import java.util.Vector;

public final class ConstraintSOAPReferenceFactory
implements ISOAPReferenceFactory,
IFabricConstants {
    public boolean newSOAPReference(Vector referenceChain, XURL endpoint, WSDL wsdl, Context proxyContext) {
        if (endpoint.getProtocol() != null) {
            return false;
        }
        String path = endpoint.getFile();
        if (!path.startsWith("?glue")) {
            return false;
        }
        this.processAuthorization(path, proxyContext);
        try {
            ISOAPReference soapReference;
            ServicePath selection = Fabric.getServiceManager().selectService(path);
            if (selection == null) {
                return false;
            }
            wsdl = selection.getServiceInfo().getWSDL();
            String newPath = null;
            newPath = selection.getIntermediary() == null ? selection.getServiceInfo().getEndpoint() : selection.getIntermediary() + "?glue" + "&" + "service.wsdl" + "=" + selection.getServiceInfo().getWSDLURL();
            if (HTTPUtil.hasParameter(path, "monitor")) {
                newPath = HTTPUtil.addParameter(newPath, "monitor");
            }
            if ((soapReference = this.getSOAPReference(endpoint = new XURL(newPath), wsdl, proxyContext)) == null) {
                return false;
            }
            referenceChain.addElement(soapReference);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void processAuthorization(String path, Context proxyContext) {
        String wsdlAuthUser = HTTPUtil.getParameter(path, "wsdl.authuser");
        String wsdlAuthPassword = HTTPUtil.getParameter(path, "wsdl.authpass");
        if (wsdlAuthUser != null) {
            proxyContext.setProperty("authUser", wsdlAuthUser);
        }
        if (wsdlAuthPassword != null) {
            proxyContext.setProperty("authPassword", wsdlAuthPassword);
        }
    }

    public ISOAPReference getSOAPReference(XURL endpoint, WSDL wsdl, Context proxyContext) {
        int index = SOAPReferenceFactories.getIndex(this);
        return SOAPReferenceFactories.newSOAPReference(endpoint, wsdl, proxyContext, index);
    }
}

