/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services.broker.uddi;

import electric.fabric.IFabricConstants;
import electric.fabric.services.broker.uddi.UDDIBroker;
import electric.uddi.admin.IAdmin;
import electric.uddi.admin.User;
import electric.uddi.client.UDDIClient;
import electric.uddi.server.UDDIServer;
import electric.uddi.server.xdb.XDBUDDIStorage;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xdb.IActiveData;
import electric.xdb.IXDBConstants;
import electric.xdb.XDBException;
import electric.xdb.server.IXDBServer;
import electric.xdb.server.IXDBServersListener;
import electric.xdb.server.LocalXDBServers;

public class XDBUDDIServer
implements IActiveData,
IFabricConstants,
IXDBConstants,
IXDBServersListener,
ILoggingConstants {
    private String inquiryURL;
    private String publicationURL;
    private String adminURL;
    private String user;
    private String password;
    private String operatorName;
    private String businessName;
    private transient UDDIServer uddiServer;
    private transient UDDIBroker uddiBroker;

    public XDBUDDIServer() {
    }

    public XDBUDDIServer(String inquiryURL, String publicationURL, String adminURL, String user, String password, String operatorName, String businessName) {
        this.inquiryURL = inquiryURL;
        this.publicationURL = publicationURL;
        this.adminURL = adminURL;
        this.user = user;
        this.password = password;
        this.operatorName = operatorName;
        this.businessName = businessName;
    }

    public boolean isMany() {
        return true;
    }

    public void activate(IXDBServer server) {
        LocalXDBServers.addListener(this);
    }

    public void deactivate(IXDBServer server) {
        this.uddiBroker.shutdown();
    }

    public void addedLocalServer(IXDBServer server) {
        try {
            if (!server.getGroup().equals("services")) {
                return;
            }
        }
        catch (XDBException exception) {
            // empty catch block
        }
        this.initUDDI(server);
    }

    public void removedLocalServer(IXDBServer server) {
    }

    private void initUDDI(IXDBServer server) {
        block3: {
            try {
                boolean first = server.getContext().getProperty("first") != null;
                XDBUDDIStorage factory = new XDBUDDIStorage(server, false);
                this.uddiServer = new UDDIServer(this.inquiryURL, this.publicationURL, this.adminURL, factory, first);
                this.uddiServer.setOperator(this.operatorName);
                if (first) {
                    IAdmin admin = this.uddiServer.getAdmin();
                    User uddiUser = new User(this.user, this.password);
                    uddiUser.setPublish(true);
                    admin.saveUser(uddiUser);
                }
                UDDIClient uddiClient = new UDDIClient(this.inquiryURL, this.publicationURL, this.user, this.password);
                this.uddiBroker = new UDDIBroker(uddiClient, this.businessName);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block3;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "could not init UDDI server", exception);
            }
        }
    }

    public UDDIBroker getUDDIBroker() {
        return this.uddiBroker;
    }
}

