/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services.broker.uddi;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.ServiceInfo;
import electric.fabric.services.broker.IBroker;
import electric.fabric.services.broker.LocalBrokers;
import electric.glue.context.ServiceContext;
import electric.registry.Registry;
import electric.uddi.AccessPoint;
import electric.uddi.Binding;
import electric.uddi.Business;
import electric.uddi.BusinessInfos;
import electric.uddi.Category;
import electric.uddi.Description;
import electric.uddi.Identifier;
import electric.uddi.Name;
import electric.uddi.Overview;
import electric.uddi.Service;
import electric.uddi.ServiceInfos;
import electric.uddi.Services;
import electric.uddi.TModel;
import electric.uddi.TModelInfos;
import electric.uddi.TModelInstance;
import electric.uddi.UDDIException;
import electric.uddi.client.UDDIClient;
import electric.util.Context;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.wsdl.util.SignatureGenerator;
import electric.xdb.IXDBConstants;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Vector;

public class UDDIBroker
implements IBroker,
IFabricConstants,
IXDBConstants,
ILoggingConstants {
    private UDDIClient uddiClient;
    private String businessName;
    private String url;
    private String defaultBusinessKey;
    static /* synthetic */ Class class$electric$fabric$services$broker$IBroker;
    static /* synthetic */ Class class$electric$xdb$server$IXDBServer;

    public UDDIBroker(UDDIClient uddiClient, String businessName) {
        this.uddiClient = uddiClient;
        this.businessName = businessName;
        this.startup();
    }

    public String getInquiryURL() {
        return this.uddiClient.getInquiryURL();
    }

    public String getPublicationURL() {
        return this.uddiClient.getPublicationURL();
    }

    public void startup() {
        block2: {
            try {
                ServiceContext context = new ServiceContext();
                context.setDocumentStyle();
                Registry.publish("/fabric/broker", (Object)this, class$electric$fabric$services$broker$IBroker == null ? (class$electric$fabric$services$broker$IBroker = UDDIBroker.class$("electric.fabric.services.broker.IBroker")) : class$electric$fabric$services$broker$IBroker, (Context)context);
                this.url = Fabric.isServer() ? Registry.getPath(this) + ".wsdl" : "/fabric/broker";
                LocalBrokers.addedBroker(this);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during UDDI broker startup", exception);
            }
        }
    }

    public void shutdown() {
        block2: {
            try {
                Registry.unpublish("/fabric/broker");
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during UDDI broker shutdown", exception);
            }
        }
    }

    public String getURL() {
        return this.url;
    }

    public void publish(ServiceInfo serviceInfo) {
        block5: {
            String businessKey = this.getDefaultBusinessKey();
            String signature = serviceInfo.getSignature();
            try {
                String tModelKey = this.getTModelKeyForSignature(signature, serviceInfo.getWSDLURL());
                String serviceKey = this.getServiceKeyForEndpoint(serviceInfo.getEndpoint());
                Service service = new Service("name");
                service.setBusinessKey(businessKey);
                if (serviceKey != null) {
                    service.setServiceKey(serviceKey);
                }
                Description description = new Description(serviceInfo.getDescription());
                Description[] descriptions = new Description[]{description};
                service.setDescriptions(descriptions);
                Binding binding = new Binding();
                TModelInstance tModelInstance = new TModelInstance(tModelKey);
                binding.addTModelInstance(tModelInstance);
                binding.addDescription(new Description("SOAP binding"));
                AccessPoint accessPoint = new AccessPoint(serviceInfo.getEndpoint(), "http");
                binding.setAccessPoint(accessPoint);
                service.addBinding(binding);
                Element element = serviceInfo.getMetadata();
                if (element != null) {
                    Elements elements = element.getElements();
                    while (elements.hasMoreElements()) {
                        Element e = elements.next();
                        String key = e.getName();
                        String value = e.getString();
                        service.addCategory(new Category(key, value));
                    }
                }
                service = this.uddiClient.saveService(service);
            }
            catch (UDDIException exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block5;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during UDDI broker publish", exception);
            }
        }
    }

    private String getTModelKeyForSignature(String signature, String wsdlURL) throws UDDIException {
        Identifier identifier = new Identifier("signature", signature);
        Identifier[] identifiers = new Identifier[]{identifier};
        TModelInfos tModelInfos = this.uddiClient.findTModels(null, identifiers, null, null);
        if (tModelInfos.list.length > 0) {
            return tModelInfos.list[0].getTModelKey();
        }
        TModel tModel = new TModel("signature-" + signature);
        tModel.addIdentifier(identifier);
        Description description = new Description("overview");
        Overview overview = new Overview(description, wsdlURL);
        tModel.setOverview(overview);
        Category category = new Category("uddi-org:types", "wsdlSpec", "uuid:C1ACF26D-9672-4404-9D70-39B756E62AB4");
        tModel.addCategory(category);
        tModel = this.uddiClient.saveTModel(tModel);
        return tModel.getTModelKey();
    }

    private String getServiceKeyForEndpoint(String endpoint) throws UDDIException {
        Category category = new Category("endpoint", endpoint);
        Category[] categories = new Category[]{category};
        ServiceInfos serviceInfos = this.uddiClient.findServices(null, null, categories, null, null);
        return serviceInfos.list.length == 0 ? null : serviceInfos.list[0].getServiceKey();
    }

    public void unpublish(String endpoint) {
        block2: {
            try {
                String serviceKey = this.getServiceKeyForEndpoint(endpoint);
                this.uddiClient.deleteService(serviceKey);
            }
            catch (UDDIException exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during UDDI broker unpublish", exception);
            }
        }
    }

    public ServiceInfo getServiceInfoForEndpoint(String endpoint) {
        try {
            String serviceKey = this.getServiceKeyForEndpoint(endpoint);
            Service service = this.uddiClient.getService(serviceKey);
            return this.getServiceInfoForService(service);
        }
        catch (UDDIException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during UDDI broker getServiceInfoForEndpoint", exception);
            }
            return null;
        }
    }

    private ServiceInfo getServiceInfoForService(Service service) {
        ServiceInfo serviceInfo = new ServiceInfo();
        AccessPoint accessPoint = service.getBindings()[0].getAccessPoint();
        serviceInfo.setEndpoint(accessPoint.getAddress());
        serviceInfo.setDescription(service.getDescriptions()[0].getText());
        Category[] categories = service.getCategories();
        int i = 0;
        while (i < categories.length) {
            serviceInfo.addMetadata(categories[i].getName(), categories[i].getValue());
            ++i;
        }
        return serviceInfo;
    }

    public ServiceInfo[] getServiceInfoForConstraint(ServiceInfo constraint) {
        try {
            Category[] categories = this.getCategories(constraint);
            ServiceInfos serviceInfos = this.uddiClient.findServices(null, null, categories, null, null);
            if (serviceInfos.list.length == 0) {
                return new ServiceInfo[0];
            }
            String[] serviceKeys = new String[serviceInfos.list.length];
            int i = 0;
            while (i < serviceKeys.length) {
                serviceKeys[i] = serviceInfos.list[i].getServiceKey();
                ++i;
            }
            Services services = this.uddiClient.getServices(serviceKeys);
            ServiceInfo[] serviceInfos2 = new ServiceInfo[services.list.length];
            int i2 = 0;
            while (i2 < serviceInfos2.length) {
                serviceInfos2[i2] = this.getServiceInfoForService(services.list[i2]);
                ++i2;
            }
            return serviceInfos2;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during UDDI broker getServiceInfoForConstraint", exception);
            }
            return new ServiceInfo[0];
        }
    }

    private Category[] getCategories(ServiceInfo constraint) {
        Element element = constraint.getMetadata();
        if (element == null) {
            return new Category[0];
        }
        Elements elements = element.getElements();
        Category[] categories = new Category[elements.size()];
        int i = 0;
        while (i < categories.length) {
            Element e = elements.next();
            categories[i] = new Category(e.getName(), e.getString());
            ++i;
        }
        return categories;
    }

    public int getServiceCount() {
        try {
            Name[] names = new Name[]{new Name("%")};
            ServiceInfos infos = this.uddiClient.findServices(null, names, null, null, null);
            return infos.list.length;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public ServiceInfo[] getAllServiceInfo() {
        try {
            Name[] names = new Name[]{new Name("%")};
            ServiceInfos infos = this.uddiClient.findServices(null, names, null, null, null);
            String[] serviceKeys = new String[infos.list.length];
            int i = 0;
            while (i < serviceKeys.length) {
                serviceKeys[i] = infos.list[i].getServiceKey();
                ++i;
            }
            Services services = this.uddiClient.getServices(serviceKeys);
            ServiceInfo[] array = new ServiceInfo[infos.list.length];
            int i2 = 0;
            while (i2 < array.length) {
                array[i2] = this.getServiceInfoForService(services.list[i2]);
                ++i2;
            }
            return array;
        }
        catch (Exception exception) {
            return new ServiceInfo[0];
        }
    }

    private synchronized String getDefaultBusinessKey() {
        block4: {
            if (this.defaultBusinessKey != null) {
                return this.defaultBusinessKey;
            }
            try {
                Name[] names = new Name[]{new Name(this.businessName)};
                BusinessInfos businessInfos = this.uddiClient.findBusinesses(names, null, null, null, null, null);
                if (businessInfos.list.length == 0) {
                    Business business = new Business(this.businessName);
                    Business savedBusiness = this.uddiClient.saveBusiness(business);
                    this.defaultBusinessKey = savedBusiness.getBusinessKey();
                    break block4;
                }
                this.defaultBusinessKey = businessInfos.list[0].getBusinessKey();
            }
            catch (UDDIException exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block4;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during UDDI broker getDefaultBusinessKey", exception);
            }
        }
        return this.defaultBusinessKey;
    }

    public String[] getGroups() {
        ServiceInfo constraint = new ServiceInfo();
        String signature = SignatureGenerator.getDocLitSignature(class$electric$xdb$server$IXDBServer == null ? (class$electric$xdb$server$IXDBServer = UDDIBroker.class$("electric.xdb.server.IXDBServer")) : class$electric$xdb$server$IXDBServer);
        constraint.setSignature(signature);
        ServiceInfo[] serviceInfos = this.getServiceInfoForConstraint(constraint);
        Vector<String> vector = new Vector<String>();
        int i = 0;
        while (i < serviceInfos.length) {
            String group = serviceInfos[i].getMetadata("group");
            if (!vector.contains(group)) {
                vector.addElement(group);
            }
            ++i;
        }
        Object[] groups = new String[vector.size()];
        vector.copyInto(groups);
        return groups;
    }

    public void livenessPing() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

