/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.rules;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.rules.IRuleManager;
import electric.fabric.rules.Rule;
import electric.fabric.rules.RuleManagerException;
import electric.fabric.services.ServiceInfo;
import electric.glue.context.ServiceContext;
import electric.proxy.IReference;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.util.Context;
import electric.xdb.Data;
import electric.xdb.Query;
import electric.xdb.XDBException;
import electric.xdb.client.IXDBClient;
import electric.xdb.client.XDBClients;

public final class RuleManager
implements IRuleManager,
IFabricConstants {
    private IReference reference;
    private IXDBClient rules = XDBClients.getClient("rules");
    static /* synthetic */ Class class$electric$fabric$rules$IRuleManager;

    public RuleManager() throws RegistryException {
        ServiceContext context = new ServiceContext();
        context.setDocumentStyle();
        Registry.publish("/fabric/ruleManager", (Object)this, class$electric$fabric$rules$IRuleManager == null ? (class$electric$fabric$rules$IRuleManager = RuleManager.class$("electric.fabric.rules.IRuleManager")) : class$electric$fabric$rules$IRuleManager, (Context)context);
    }

    public synchronized IReference getReference() throws RegistryException {
        if (this.reference != null) {
            return this.reference;
        }
        Class[] interfaces = new Class[]{class$electric$fabric$rules$IRuleManager == null ? (class$electric$fabric$rules$IRuleManager = RuleManager.class$("electric.fabric.rules.IRuleManager")) : class$electric$fabric$rules$IRuleManager};
        Context context = new Context();
        this.reference = Registry.getReference("/fabric/ruleManager", interfaces, context);
        return this.reference;
    }

    public void start() throws Exception {
        String wsdlURL = Registry.getPath(this) + ".wsdl";
        ServiceInfo serviceInfo = new ServiceInfo(wsdlURL);
        serviceInfo.setDescription("fabric rule manager");
        serviceInfo.addMetadata("inFabricServer", "true");
        serviceInfo.addMetadata("systemService", "true");
        Fabric.getServiceManager().publishUsingInfo(serviceInfo);
    }

    public int getRuleCount() throws RuleManagerException {
        try {
            return this.rules.getDataCount();
        }
        catch (XDBException exception) {
            throw new RuleManagerException(exception);
        }
    }

    public Rule[] getRulesForQuery(Query query) throws RuleManagerException {
        try {
            Data[] matches = this.rules.getDataForQuery(query);
            Rule[] rules = new Rule[matches.length];
            int i = 0;
            while (i < matches.length) {
                rules[i] = (Rule)matches[i].getObject();
                ++i;
            }
            return rules;
        }
        catch (XDBException exception) {
            throw new RuleManagerException(exception);
        }
    }

    public Rule getRule(String key) throws RuleManagerException {
        try {
            Data data = this.rules.getDataForKey(key);
            return data == null ? null : (Rule)data.getObject();
        }
        catch (XDBException exception) {
            throw new RuleManagerException(exception);
        }
    }

    public void addRule(Rule rule) throws RuleManagerException {
        try {
            Data data = new Data(rule.getKey(), (Object)rule);
            this.rules.addData(data);
        }
        catch (XDBException exception) {
            throw new RuleManagerException(exception);
        }
    }

    public void removeRule(String key) throws RuleManagerException {
        try {
            this.rules.removeDataForKey(key);
        }
        catch (XDBException exception) {
            throw new RuleManagerException(exception);
        }
    }

    public void removeRules(String[] keys) throws RuleManagerException {
        try {
            this.rules.removeDataForKeys(keys);
        }
        catch (XDBException exception) {
            throw new RuleManagerException(exception);
        }
    }

    public void removeAllRules() throws RuleManagerException {
        try {
            this.rules.removeAllData();
        }
        catch (XDBException exception) {
            throw new RuleManagerException(exception);
        }
    }

    public void livenessPing() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

