/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.nodes;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.nodes.INodeManager;
import electric.fabric.nodes.NodeInfo;
import electric.fabric.nodes.NodeManagerException;
import electric.fabric.nodes.liveness.NodeLiveness;
import electric.fabric.services.ServiceInfo;
import electric.glue.context.ServiceContext;
import electric.proxy.IReference;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.IServer;
import electric.server.Servers;
import electric.util.Context;
import electric.util.XURL;
import electric.util.time.TimeUtil;
import electric.xdb.Data;
import electric.xdb.IXDBConstants;
import electric.xdb.Id;
import electric.xdb.Query;
import electric.xdb.client.IXDBClient;
import electric.xdb.client.XDBClients;
import electric.xml.Element;

public final class NodeManager
implements INodeManager,
IFabricConstants,
IXDBConstants {
    private IReference reference;
    private IXDBClient nodes = XDBClients.getClient("nodes");
    private NodeInfo nodeInfo;
    static /* synthetic */ Class class$electric$fabric$nodes$INodeManager;

    public NodeManager() throws RegistryException {
        ServiceContext context = new ServiceContext();
        context.setDocumentStyle();
        Registry.publish("/fabric/nodeManager", (Object)this, class$electric$fabric$nodes$INodeManager == null ? (class$electric$fabric$nodes$INodeManager = NodeManager.class$("electric.fabric.nodes.INodeManager")) : class$electric$fabric$nodes$INodeManager, (Context)context);
    }

    public synchronized IReference getReference() throws RegistryException {
        if (this.reference != null) {
            return this.reference;
        }
        Class[] interfaces = new Class[]{class$electric$fabric$nodes$INodeManager == null ? (class$electric$fabric$nodes$INodeManager = NodeManager.class$("electric.fabric.nodes.INodeManager")) : class$electric$fabric$nodes$INodeManager};
        Context context = new Context();
        this.reference = Registry.getReference("/fabric/nodeManager", interfaces, context);
        return this.reference;
    }

    public void start() throws Exception {
        String wsdlURL = Registry.getPath(this) + ".wsdl";
        ServiceInfo serviceInfo = new ServiceInfo(wsdlURL);
        serviceInfo.setDescription("fabric node manager");
        serviceInfo.addMetadata("inFabricServer", "true");
        serviceInfo.addMetadata("systemService", "true");
        Fabric.getServiceManager().publishUsingInfo(serviceInfo);
        boolean persistence = Fabric.hasPersistence();
        this.nodeInfo = new NodeInfo(this.getServerPath(), true, TimeUtil.now(), Fabric.isServer(), Fabric.isServer(), persistence);
        Data data1 = new Data(this.nodeInfo.getURL(), (Object)this.nodeInfo);
        Data data2 = new Data(new Id("liveness", 1000L), (Object)new NodeLiveness());
        this.nodes.addDataArray(new Data[]{data1, data2});
    }

    private String getServerPath() {
        IServer[] servers = Servers.getServersForProtocol("http");
        if (servers == null || servers.length == 0) {
            servers = Servers.getServersForProtocol("https");
        }
        XURL xurl = servers[0].getPath();
        return xurl.toString();
    }

    public void addNodeInfo(NodeInfo nodeInfo) throws NodeManagerException {
        try {
            Data data = new Data(nodeInfo.getURL(), (Object)nodeInfo);
            this.nodes.addData(data);
        }
        catch (Exception exception) {
            throw new NodeManagerException(exception);
        }
    }

    public int getNodeCount() throws NodeManagerException {
        try {
            return this.nodes.getDataCount() - 1;
        }
        catch (Exception exception) {
            throw new NodeManagerException(exception);
        }
    }

    public NodeInfo[] getAllNodeInfo(boolean includeOffline) throws NodeManagerException {
        try {
            Element envelope = new Element("Envelope");
            Element body = envelope.addElement("Body");
            Element nodeInfoElement = body.addElement("NodeInfo");
            if (!includeOffline) {
                nodeInfoElement.setBoolean("online", true);
            }
            Query query = new Query(envelope);
            Data[] matches = this.nodes.getDataForQuery(query);
            NodeInfo[] nodeInfo = new NodeInfo[matches.length];
            int i = 0;
            while (i < matches.length) {
                nodeInfo[i] = (NodeInfo)matches[i].getObject();
                ++i;
            }
            return nodeInfo;
        }
        catch (Exception exception) {
            throw new NodeManagerException(exception);
        }
    }

    public void removeNodeInfo(String url) throws NodeManagerException {
        try {
            this.nodes.removeDataForKey(url);
        }
        catch (Exception exception) {
            throw new NodeManagerException(exception);
        }
    }

    public void livenessPing() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

