/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.console.services;

import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.fabric.Fabric;
import electric.fabric.console.services.ILogConstants;
import electric.fabric.logs.LogEntry;
import electric.fabric.logs.LogManagerException;
import electric.util.log.ILoggingConstants;
import electric.xml.Document;
import electric.xml.Element;
import java.util.Hashtable;

public class Log
implements ILoggingConstants,
IConsoleModule,
ITreeViewProducer,
ILogConstants,
IConsoleConstants {
    private static final int MAX_ENTRIES = 50;
    private ConsoleModuleInfo moduleInfo;

    public Document getLogEntries(Hashtable args) {
        String category = (String)args.get("filter");
        String endpoint = (String)args.get("endpoint");
        String systemType = (String)args.get("system");
        boolean ignoreSystem = systemType.equalsIgnoreCase("false");
        try {
            LogEntry[] logEntries = Fabric.getLogManager().getLogEntriesWithCategoryAndEndpoint(category, endpoint, 50);
            Document doc = new Document();
            Element root = doc.setRoot("LogEntries");
            Element nodes = root.addElement("Logs");
            int i = 0;
            while (i < logEntries.length) {
                LogEntry entry = logEntries[i];
                if (!ignoreSystem || !entry.getCategory().equalsIgnoreCase("SYSTEM")) {
                    Element node = nodes.addElement("Log");
                    node.setString("message", entry.getMessage());
                    node.setString("category", entry.getCategory());
                    node.setLong("timestamp", entry.getTimestamp());
                }
                ++i;
            }
            return doc;
        }
        catch (Exception exception) {
            if (electric.util.log.Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                electric.util.log.Log.log(ILoggingConstants.ERROR_EVENT, "unable to get node list", exception);
            }
            return new Document();
        }
    }

    public Document getLogSummary() throws LogManagerException {
        Document doc = new Document();
        Element root = doc.setRoot("LogEntries");
        root.setInt("numLogs", Fabric.getLogManager().getLogCount());
        return doc;
    }

    public String testLog(Hashtable args) {
        String theXML = (String)args.get("ruleData");
        String testGetBack = "&errorCode=0&message=";
        return testGetBack;
    }

    public void clearAllEntries(Hashtable args) throws LogManagerException {
        String endpoint = (String)args.get("endpoint");
        if (endpoint.equals("*")) {
            Fabric.getLogManager().removeAllLogEntries();
        } else {
            Fabric.getLogManager().removeAllLogEntriesForEndpoint(endpoint);
        }
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        Element element = new Element("TREE");
        element.addText("Log");
        element.setAttribute("Name", "Log");
        element.setAttribute("Function", "showDetails");
        element.setAttribute("TARGET", "_root");
        element.setAttribute("HeaderText", "Log");
        element.setAttribute("swfURL", this.moduleInfo.getSWFURL());
        element.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
        element.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
        return new Element[]{element};
    }

    public boolean isSessionAware() {
        return false;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }
}

