/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.config;

import electric.application.web.IWebApplicationListener;
import electric.application.web.WebApplication;
import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.config.DiscoveryConfig;
import electric.fabric.config.EndpointsConfig;
import electric.fabric.config.IFabricConfigConstants;
import electric.fabric.config.LivenessConfig;
import electric.fabric.config.XDBConfig;
import electric.fabric.endpoints.EndpointManager;
import electric.fabric.endpoints.handler.MonitorSOAPHandlerFactory;
import electric.fabric.endpoints.reference.MonitorSOAPReferenceFactory;
import electric.fabric.intermediary.SOAPHandler;
import electric.fabric.intermediary.WSDLHandler;
import electric.fabric.intermediary.XDBHandler;
import electric.fabric.logs.LogManager;
import electric.fabric.nodes.NodeManager;
import electric.fabric.rules.Rule;
import electric.fabric.rules.RuleManager;
import electric.fabric.rules.RuleManagerException;
import electric.fabric.rules.processors.performance.MeasurePerformance;
import electric.fabric.services.ServiceManager;
import electric.fabric.services.creation.ServiceCreator;
import electric.fabric.services.factory.ObjectFactories;
import electric.fabric.services.liveness.ServiceLiveness;
import electric.fabric.services.reference.balance.RoundRobinFactory;
import electric.fabric.services.reference.constraint.ConstraintSOAPReferenceFactory;
import electric.fabric.services.registry.FabricRegistry;
import electric.fabric.services.registry.FabricRegistryListener;
import electric.fabric.services.selection.ServiceSelector;
import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.glue.pro.config.ConsoleConfig;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.http.HTTP;
import electric.server.http.IHTTPListener;
import electric.servlet.Config;
import electric.servlet.HTTPContext;
import electric.soap.SOAPOptimizations;
import electric.soap.handlers.SOAPHandlerFactories;
import electric.soap.references.SOAPReferenceFactories;
import electric.soap.references.balance.BalanceSOAPReferenceFactory;
import electric.soap.references.rebind.RebindSOAPReferenceFactory;
import electric.soap.wsdl.SOAPBinding;
import electric.soap.wsdl.personality.dotnet.NETSOAPPersonality;
import electric.util.Context;
import electric.util.ExceptionUtil;
import electric.util.license.LicensingException;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.ProductConfig;
import electric.webserver.WebServer;
import electric.webserver.WebServers;
import electric.xdb.Data;
import electric.xdb.Id;
import electric.xdb.XDBException;
import electric.xdb.client.IXDBClient;
import electric.xdb.client.XDBClients;
import electric.xdb.server.FileLoader;
import electric.xdb.server.LocalXDBServerFactory;
import electric.xdb.server.XDBServer;
import electric.xdb.server.XDBServerFactory;
import electric.xdb.store.factory.memory.MemoryStoreFactory;
import electric.xml.Element;
import electric.xml.config.LoggingConfig;
import javax.servlet.Servlet;

public final class FabricPlugin
extends ProductConfig
implements IFabricConfigConstants,
IHTTPListener,
IWebApplicationListener,
IFabricConstants,
IGLUELoggingConstants,
IGLUEContextConstants {
    private static final String FABRIC = "Fabric";
    private static final int ID = 6;
    private static final int MAJOR = 1;
    private static final int MINOR = 0;
    private static final int PATCH = 0;
    private static boolean internalUseOnly = false;
    private static String[] BINDING_ALLOWED_INTERFACES = new String[]{"electric.cluster.manager.IClusterManager", "electric.cluster.IClusteredApplication", "electric.fabric.services.IServiceManager", "electric.xdb.server.IXDBServer"};
    private String constructorCaller;
    private String fabricInitCaller;
    static /* synthetic */ Class class$electric$fabric$rules$IRuleManager;
    static /* synthetic */ Class class$electric$fabric$endpoints$IEndpointManager;
    static /* synthetic */ Class class$electric$fabric$logs$ILogManager;
    static /* synthetic */ Class class$electric$fabric$nodes$INodeManager;
    static /* synthetic */ Class class$electric$fabric$services$IServiceManager;
    static /* synthetic */ Class class$electric$util$product$Product;
    static /* synthetic */ Class class$electric$fabric$Fabric;

    public FabricPlugin() {
        super(FABRIC, 6, 1, 0, 0);
        this.initInternalUseProps();
    }

    public void configure(Element config) throws Throwable {
        this.internalUseCheck();
        new LoggingConfig().config(config);
        FabricPlugin.initClient();
        new DiscoveryConfig().config(config);
    }

    private static void initClient() throws Exception {
        FabricPlugin.initSOAPOptimizations();
        FabricPlugin.initSOAPPersonality();
        FabricPlugin.initRegistry();
        FabricPlugin.initSOAPReferenceFactories();
        FabricPlugin.initSOAPHandlerFactories();
        FabricPlugin.initObjectFactories();
        FabricPlugin.initStoreFactory();
        FabricPlugin.initServiceManager();
        FabricPlugin.initReferenceMappings();
    }

    private static void initSOAPOptimizations() {
        SOAPOptimizations.disableAllOptimizations();
        SOAPOptimizations.setTypeOmissionEnabled(true);
    }

    private static void initSOAPPersonality() {
        SOAPBinding.setDefaultSOAPPersonality(new NETSOAPPersonality());
    }

    private static void initRegistry() {
        Fabric.setRegistryListener(new FabricRegistryListener());
        Fabric.autoPublish("shared");
        Fabric.setNoPath("fabric://failover&monitor");
        FabricRegistry registry = new FabricRegistry((String[])(internalUseOnly ? BINDING_ALLOWED_INTERFACES : null));
        registry.mapInterfaceToStyle(class$electric$fabric$rules$IRuleManager == null ? (class$electric$fabric$rules$IRuleManager = FabricPlugin.class$("electric.fabric.rules.IRuleManager")) : class$electric$fabric$rules$IRuleManager, "document");
        registry.mapInterfaceToStyle(class$electric$fabric$endpoints$IEndpointManager == null ? (class$electric$fabric$endpoints$IEndpointManager = FabricPlugin.class$("electric.fabric.endpoints.IEndpointManager")) : class$electric$fabric$endpoints$IEndpointManager, "document");
        registry.mapInterfaceToStyle(class$electric$fabric$logs$ILogManager == null ? (class$electric$fabric$logs$ILogManager = FabricPlugin.class$("electric.fabric.logs.ILogManager")) : class$electric$fabric$logs$ILogManager, "document");
        registry.mapInterfaceToStyle(class$electric$fabric$nodes$INodeManager == null ? (class$electric$fabric$nodes$INodeManager = FabricPlugin.class$("electric.fabric.nodes.INodeManager")) : class$electric$fabric$nodes$INodeManager, "document");
        registry.mapInterfaceToStyle(class$electric$fabric$services$IServiceManager == null ? (class$electric$fabric$services$IServiceManager = FabricPlugin.class$("electric.fabric.services.IServiceManager")) : class$electric$fabric$services$IServiceManager, "document");
        Registry.addRegistry("fabric", registry, 2.0f);
    }

    private static void initSOAPReferenceFactories() {
        SOAPReferenceFactories.addFactory("failover", new RebindSOAPReferenceFactory(), 4.1f);
        SOAPReferenceFactories.addFactory("balance", new BalanceSOAPReferenceFactory(new RoundRobinFactory()), 4.2f);
        SOAPReferenceFactories.addFactory("monitor", new MonitorSOAPReferenceFactory(), 4.3f);
        SOAPReferenceFactories.addFactory("constraint", new ConstraintSOAPReferenceFactory(), 4.4f);
    }

    private static void initSOAPHandlerFactories() {
        SOAPHandlerFactories.addFactory("monitor", new MonitorSOAPHandlerFactory(), 2.1f);
    }

    private static void initObjectFactories() {
        ObjectFactories.addFactory(new XDBServerFactory());
    }

    private static void initStoreFactory() {
        XDBServer.setDefaultStoreFactory(new MemoryStoreFactory());
    }

    private static void initServiceManager() throws RegistryException {
        ServiceManager serviceManager = new ServiceManager();
        serviceManager.setCreator(new ServiceCreator(serviceManager));
        serviceManager.setSelector(new ServiceSelector(serviceManager));
        Fabric.setServiceManager(serviceManager);
    }

    private static void initReferenceMappings() throws RegistryException {
        FabricRegistry registry = (FabricRegistry)Registry.getRegistry("fabric");
        registry.mapInterfaceToReference(class$electric$fabric$services$IServiceManager == null ? (class$electric$fabric$services$IServiceManager = FabricPlugin.class$("electric.fabric.services.IServiceManager")) : class$electric$fabric$services$IServiceManager, Fabric.getServiceManager().getReference());
    }

    public void configureAsServer(Element config, Object application) throws Throwable {
        this.internalUseCheck();
        ConsoleConfig.addConsoleModule(FABRIC);
        new XDBConfig().config(config);
        new EndpointsConfig().config(config);
        new LivenessConfig().config(config);
        if (application == null) {
            HTTP.addListener(this);
        } else {
            ((WebApplication)application).addListener(this);
        }
    }

    public void executeLicenseConstraints() {
        String nodeLockString = (String)this.getProductInfo().getLicenseInfo().getProperty("nodeLockInfo");
        if (nodeLockString != null && nodeLockString.charAt(1) == '6') {
            internalUseOnly = true;
        }
    }

    private static void initServer() throws Exception {
        Fabric.setServer(true);
        FabricPlugin.initWSDLServlet();
        FabricPlugin.initDataServlet();
        FabricPlugin.initSOAPHandler();
        FabricPlugin.createManagers();
        FabricPlugin.initInterfaceMappings();
        FabricPlugin.initFileBasedPersistence();
        FabricPlugin.startManagers();
        FabricPlugin.initRules();
        FabricPlugin.initServiceLiveness();
    }

    public static void initWSDLServlet() {
        Config gaiaWsdlServletConfig = new Config("fabric-wsdl", (Servlet)new WSDLHandler());
        WebServer[] webServers = WebServers.getWebServers();
        int i = 0;
        while (i < webServers.length) {
            HTTPContext[] contexts = webServers[i].getAllContexts();
            int k = 0;
            while (k < contexts.length) {
                contexts[k].addConfig("/wsdl/*", gaiaWsdlServletConfig);
                ++k;
            }
            ++i;
        }
    }

    private static void initDataServlet() {
        Config gaiaXDBServletConfig = new Config("fabric-xdb", (Servlet)new XDBHandler());
        WebServer[] webServers = WebServers.getWebServers();
        int i = 0;
        while (i < webServers.length) {
            HTTPContext[] contexts = webServers[i].getAllContexts();
            int k = 0;
            while (k < contexts.length) {
                contexts[k].addConfig("/data/*", gaiaXDBServletConfig);
                ++k;
            }
            ++i;
        }
    }

    public static void initSOAPHandler() throws RegistryException {
        SOAPHandler soapHandler = new SOAPHandler();
        Registry.publish("/fabric/soap", soapHandler);
        Fabric.setSOAPHandler(soapHandler);
    }

    private static void createManagers() throws RegistryException {
        Fabric.setEndpointManager(new EndpointManager());
        Fabric.setNodeManager(new NodeManager());
        Fabric.setRuleManager(new RuleManager());
        Fabric.setLogManager(new LogManager());
    }

    private static void initInterfaceMappings() throws RegistryException {
        FabricRegistry registry = (FabricRegistry)Registry.getRegistry("fabric");
        registry.mapInterfaceToReference(class$electric$fabric$endpoints$IEndpointManager == null ? (class$electric$fabric$endpoints$IEndpointManager = FabricPlugin.class$("electric.fabric.endpoints.IEndpointManager")) : class$electric$fabric$endpoints$IEndpointManager, Fabric.getEndpointManager().getReference());
        registry.mapInterfaceToReference(class$electric$fabric$nodes$INodeManager == null ? (class$electric$fabric$nodes$INodeManager = FabricPlugin.class$("electric.fabric.nodes.INodeManager")) : class$electric$fabric$nodes$INodeManager, Fabric.getNodeManager().getReference());
        registry.mapInterfaceToReference(class$electric$fabric$rules$IRuleManager == null ? (class$electric$fabric$rules$IRuleManager = FabricPlugin.class$("electric.fabric.rules.IRuleManager")) : class$electric$fabric$rules$IRuleManager, Fabric.getRuleManager().getReference());
        registry.mapInterfaceToReference(class$electric$fabric$logs$ILogManager == null ? (class$electric$fabric$logs$ILogManager = FabricPlugin.class$("electric.fabric.logs.ILogManager")) : class$electric$fabric$logs$ILogManager, Fabric.getLogManager().getReference());
    }

    private static void initFileBasedPersistence() {
        String delete;
        String root = Context.getSystemProperty("fabric.root");
        if (root != null) {
            delete = Context.getSystemProperty("fabric.delete", "false");
            Fabric.setRoot(root);
            Fabric.setDelete(delete.equalsIgnoreCase("true") || delete.equalsIgnoreCase("yes"));
        }
        if (Fabric.getRoot() != null) {
            delete = Context.getSystemProperty("fabric.delete", "false");
            Fabric.setRoot(root);
            Fabric.setDelete(delete.equalsIgnoreCase("true") || delete.equalsIgnoreCase("yes"));
            if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
                Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("restore xdb servers, root=" + Fabric.getRoot() + ", delete=" + Fabric.isDelete()));
            }
            FileLoader loader = new FileLoader(Fabric.getRoot(), Fabric.isDelete());
            LocalXDBServerFactory.setLoader(loader);
            XDBServer.setDefaultStoreFactory(loader);
        }
    }

    private static void startManagers() throws Exception {
        Fabric.getServiceManager().start();
        Fabric.getNodeManager().start();
        Fabric.getEndpointManager().start();
        Fabric.getRuleManager().start();
        Fabric.getLogManager().start();
    }

    private static void initRules() throws RuleManagerException {
        Rule rule = new Rule("performance", "*", 1.0f, new MeasurePerformance());
        Fabric.getRuleManager().addRule(rule);
    }

    private static void initServiceLiveness() {
        IXDBClient services = XDBClients.getClient("services");
        try {
            Data data = services.getDataForKey("liveness");
            if (data == null) {
                data = new Data(new Id("liveness", 1000L), (Object)new ServiceLiveness());
                services.addData(data);
            }
        }
        catch (XDBException exception) {}
    }

    public void startedServers() {
        try {
            FabricPlugin.initServer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stoppedServers() {
    }

    public void startedSOAPHTTPServer() {
        try {
            FabricPlugin.initServer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void internalUseCheck() {
        if (!internalUseOnly) {
            return;
        }
        int thisPosition = ExceptionUtil.getStackTracePos(this.getClass().getName());
        int productClassPosition = ExceptionUtil.getStackTracePos((class$electric$util$product$Product == null ? (class$electric$util$product$Product = FabricPlugin.class$("electric.util.product.Product")) : class$electric$util$product$Product).getName());
        if (this.constructorCaller.indexOf((class$electric$fabric$Fabric == null ? (class$electric$fabric$Fabric = FabricPlugin.class$("electric.fabric.Fabric")) : class$electric$fabric$Fabric).getName()) == -1 || this.fabricInitCaller.indexOf("electric.cluster.tools.EnterpriseServer") == -1 && this.fabricInitCaller.indexOf("electric.cluster.dispatcher.DispatcherServlet") == -1 && this.fabricInitCaller.indexOf("electric.glue.enterprise.config.Config") == -1 || productClassPosition == -1 || thisPosition - productClassPosition > 2) {
            throw new LicensingException("Fabric license is reserved only for the internal use");
        }
    }

    private void initInternalUseProps() {
        this.constructorCaller = ExceptionUtil.getClassInPos(this.getClass().getName() + ".<init>", 1);
        this.fabricInitCaller = ExceptionUtil.getClassInPos(this.getClass().getName() + ".<init>", 2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

