/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric;

import electric.fabric.IFabricConstants;
import electric.fabric.config.FabricPlugin;
import electric.fabric.endpoints.EndpointManager;
import electric.fabric.intermediary.SOAPHandler;
import electric.fabric.jaxrpc.FabricServiceFactory;
import electric.fabric.logs.LogManager;
import electric.fabric.nodes.NodeManager;
import electric.fabric.rules.RuleManager;
import electric.fabric.services.ServiceManager;
import electric.fabric.services.registry.FabricRegistryListener;
import electric.glue.IGLUELoggingConstants;
import electric.registry.Registry;
import electric.registry.nopath.NoPathRegistry;
import electric.util.http.HTTPUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.Product;

public class Fabric
implements IFabricConstants,
IGLUELoggingConstants {
    private static boolean server;
    private static ServiceManager serviceManager;
    private static EndpointManager endpointManager;
    private static NodeManager nodeManager;
    private static RuleManager ruleManager;
    private static LogManager logManager;
    private static FabricRegistryListener registryListener;
    private static SOAPHandler soapHandler;
    private static String root;
    private static boolean delete;
    private static boolean initJAXRPC;

    public static void join() throws Throwable {
        if (initJAXRPC) {
            Fabric.initJAXRPC();
        }
        Product.addPlugin(new FabricPlugin());
    }

    public static void setNoPath(String noPath) {
        NoPathRegistry noPathRegistry = (NoPathRegistry)Registry.getRegistry("nopath");
        if (noPathRegistry == null) {
            Registry.addRegistry("nopath", new NoPathRegistry(noPath), 1.0f);
        } else {
            noPathRegistry.setDefaultPath(noPath);
        }
    }

    public static SOAPHandler getSOAPHandler() {
        return soapHandler;
    }

    public static void setSOAPHandler(SOAPHandler soapHandler) {
        Fabric.soapHandler = soapHandler;
    }

    public static boolean hasPersistence() {
        return root != null;
    }

    public static void setRoot(String root) {
        Fabric.root = root;
    }

    public static String getRoot() {
        return root;
    }

    public static void setDelete(boolean delete) {
        Fabric.delete = delete;
    }

    public static boolean isDelete() {
        return delete;
    }

    public static void autoPublish(String directory) {
        registryListener.autoPublish(directory);
    }

    public static void setRegistryListener(FabricRegistryListener listener) {
        registryListener = listener;
    }

    public static void setServer(boolean server) {
        Fabric.server = server;
    }

    public static boolean isClient() {
        return !server;
    }

    public static boolean isServer() {
        return server;
    }

    public static boolean needsFabricFunctionality(String path) {
        return HTTPUtil.hasParameter(path, "monitor") || HTTPUtil.hasParameter(path, "failover");
    }

    public static ServiceManager getServiceManager() {
        return serviceManager;
    }

    public static void setServiceManager(ServiceManager serviceManager) {
        Fabric.serviceManager = serviceManager;
    }

    public static EndpointManager getEndpointManager() {
        return endpointManager;
    }

    public static void setEndpointManager(EndpointManager endpointManager) {
        Fabric.endpointManager = endpointManager;
    }

    public static NodeManager getNodeManager() {
        return nodeManager;
    }

    public static void setNodeManager(NodeManager nodeManager) {
        Fabric.nodeManager = nodeManager;
    }

    public static RuleManager getRuleManager() {
        return ruleManager;
    }

    public static void setRuleManager(RuleManager ruleManager) {
        Fabric.ruleManager = ruleManager;
    }

    public static LogManager getLogManager() {
        return logManager;
    }

    public static void setLogManager(LogManager logManager) {
        Fabric.logManager = logManager;
    }

    public void setInitJAXRPC(boolean initJAXRPC) {
        Fabric.initJAXRPC = initJAXRPC;
    }

    private static void initJAXRPC() {
        block2: {
            try {
                FabricServiceFactory.init();
            }
            catch (Throwable exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "initJAXRPC", exception);
            }
        }
    }

    static {
        initJAXRPC = true;
    }
}

