/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.managed;

import electric.application.Applications;
import electric.application.web.IStateConstants;
import electric.application.web.WebApplication;
import electric.application.web.managed.ManagedObject;
import electric.glue.IGLUELoggingConstants;
import electric.util.classloader.ClassLoaders;
import electric.util.classloader.TrackingClassLoader;
import electric.util.classloader.filters.AllClassesFilter;
import electric.util.classloader.filters.IClassFilter;
import electric.util.classloader.filters.PrefixFilter;
import electric.util.classpath.IClassPathEventListener;
import electric.util.log.Log;
import electric.util.path.PathUtil;
import electric.util.thread.IdleTask;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class ObjectManager
implements IStateConstants,
IGLUELoggingConstants,
IClassPathEventListener {
    protected WebApplication application;
    protected Hashtable nameToObject = new Hashtable();
    protected ClassLoader classLoader;

    public ObjectManager(WebApplication application) {
        this.application = application;
    }

    public abstract String getObjectType();

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.removeAll();
    }

    public ManagedObject get(String name) {
        name = PathUtil.normalizeSlashes(name);
        return (ManagedObject)this.nameToObject.get(name);
    }

    public synchronized void add(String name, ManagedObject object) {
        name = PathUtil.normalizeSlashes(name);
        this.nameToObject.put(name, object);
        object.setClassLoader(this.getClassLoader());
        object.start();
    }

    public synchronized void remove(String name) {
        ManagedObject object = (ManagedObject)this.nameToObject.remove(name = PathUtil.normalizeSlashes(name));
        if (object == null) {
            return;
        }
        object.stop();
    }

    public synchronized String[] getNameList() {
        String[] names = new String[this.nameToObject.size()];
        this.nameToObject.keySet().toArray(names);
        return names;
    }

    public synchronized void removeAll() {
        this.stopAll();
        this.nameToObject.clear();
    }

    public void startAll() {
        Enumeration enumeration = this.nameToObject.elements();
        while (enumeration.hasMoreElements()) {
            ((ManagedObject)enumeration.nextElement()).start();
        }
    }

    public void stopAll() {
        Enumeration enumeration = this.nameToObject.elements();
        while (enumeration.hasMoreElements()) {
            ((ManagedObject)enumeration.nextElement()).stop();
        }
    }

    void startAllInState(int state) {
        Enumeration enumeration = this.nameToObject.elements();
        while (enumeration.hasMoreElements()) {
            ((ManagedObject)enumeration.nextElement()).startIfInState(state);
        }
    }

    public void classesAdded(File[] files) {
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": classpath changed, starting unresolved " + this.getObjectType()));
        }
        this.startAllInState(5);
    }

    public void classesRemoved(File[] files) {
        if (this.classLoader instanceof TrackingClassLoader && !((TrackingClassLoader)this.classLoader).usesFiles(files)) {
            return;
        }
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": classpath changed, cycling " + this.getObjectType()));
        }
        this.classLoader = null;
        Enumeration enumeration = this.nameToObject.elements();
        while (enumeration.hasMoreElements()) {
            this.cycle((ManagedObject)enumeration.nextElement(), files);
        }
    }

    public void classesModified(File[] files) {
        if (!(this.classLoader instanceof TrackingClassLoader) || !((TrackingClassLoader)this.classLoader).usesFiles(files)) {
            return;
        }
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": classpath changed, cycling " + this.getObjectType()));
        }
        this.classLoader = null;
        Enumeration enumeration = this.nameToObject.elements();
        while (enumeration.hasMoreElements()) {
            this.cycle((ManagedObject)enumeration.nextElement(), null);
        }
    }

    private void cycle(ManagedObject deployable, File[] files) {
        IdleTask task = new IdleTask();
        deployable.stop();
        deployable.setClassLoader(this.getClassLoader());
        if (files == null || files != null && !deployable.usesFiles(files)) {
            deployable.start();
        } else {
            deployable.setState(5);
        }
        task.stop();
    }

    private synchronized ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.createClassLoader();
        }
        return this.classLoader;
    }

    private ClassLoader createClassLoader() {
        ClassLoader loader = ClassLoaders.getContextClassLoader();
        if (Applications.isHosted()) {
            return loader;
        }
        ObjectManager objectManager = this;
        if (objectManager.application.isHotDeploy()) {
            IClassFilter[] filters = new IClassFilter[]{new PrefixFilter("electric.")};
            return new TrackingClassLoader(this.application.getClassPathSource(), loader, filters);
        }
        IClassFilter[] filters = new IClassFilter[]{new AllClassesFilter()};
        return new TrackingClassLoader(this.application.getClassPathSource(), loader, filters);
    }

    public WebApplication getApplication() {
        return this.application;
    }

    private String getAppName() {
        return this.application.getAppName();
    }
}

