/*
 * Decompiled with CFR 0.152.
 */
package electric.application.tools;

import electric.application.DeploymentException;
import electric.application.IApplication;
import electric.application.tools.Utils;
import electric.service.descriptor.ServiceDescriptor;
import electric.util.mime.MIMEData;
import electric.util.string.Strings;
import electric.util.tool.ToolUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Deploy {
    private static String appName;
    private static String servicesURL;
    private static String className;
    private static String publishPath;
    private static String jarFile;
    private static String descriptorPath;

    public static void main(String[] args) {
        if (args.length == 0) {
            Deploy.printUsage();
            return;
        }
        try {
            Deploy.processArgs(args);
            Deploy.deploy();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Deploy.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: deploy [-Dname=value]* {appname | url} {file.jar | file.zip | className [-h] [-p path] | descriptor.xml [-p path]}");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value   = set java system property");
        System.out.println("  appname        = local application name");
        System.out.println("  url            = remote application service root");
        System.out.println("  file.jar       = deploy jar file");
        System.out.println("  file.zip       = deploy zip file");
        System.out.println("  classname      = deploy service with specified java class");
        System.out.println("  -h             = print help and exit");
        System.out.println("  -p path        = deploy with specified path");
        System.out.println("  descriptor.xml = deploy specified service descriptor");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("deploy app1 mypackage.MyClass");
        System.out.println("  create app1\\WEB-INF\\services\\MyClass.xml that uses mypackage.MyClass");
        System.out.println();
        System.out.println("deploy app1 mypackage.MyClass -p foo/bar");
        System.out.println("  create app1\\WEB-INF\\services\\foo\\bar.xml that uses mypackage.MyClass");
        System.out.println();
        System.out.println("deploy app1 file.jar");
        System.out.println("  copy file.jar into app1\\WEB-INF\\lib");
        System.out.println();
        System.out.println("deploy app1 myservice.xml");
        System.out.println("  copy descriptor file into app1\\WEB-INF\\services");
        System.out.println();
        System.out.println("deploy http://host:9000/app1/services myservice.xml");
        System.out.println("  copy descriptor file into WEB-INF\\services in remote application");
    }

    private static void processArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                if (appName == null) {
                    appName = arg;
                } else {
                    String extension;
                    String string = extension = arg.lastIndexOf(".") > -1 ? arg.substring(arg.lastIndexOf(".")) : null;
                    if (extension != null && extension.equalsIgnoreCase(".xml")) {
                        descriptorPath = arg;
                        descriptorPath = arg.replace('/', File.separatorChar);
                        int index = (descriptorPath = arg.replace('\\', File.separatorChar)).lastIndexOf(File.separatorChar);
                        publishPath = descriptorPath.substring(index == -1 ? 0 : index + 1, arg.lastIndexOf("."));
                    } else if (extension != null && (extension.equalsIgnoreCase(".jar") || extension.equalsIgnoreCase(".zip"))) {
                        jarFile = arg;
                    } else {
                        className = arg;
                        publishPath = extension == null ? arg : extension.substring(1);
                    }
                }
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'D': {
                        ToolUtil.setProperty(arg);
                        break;
                    }
                    case 'h': {
                        Deploy.printUsage();
                        System.exit(-1);
                    }
                    case 'p': {
                        publishPath = Strings.getString("p", args, ++i);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
        servicesURL = Utils.getServicesURL(appName);
    }

    private static void deploy() throws DeploymentException, IOException {
        IApplication application = Utils.bindToApplication(servicesURL);
        if (jarFile != null) {
            Deploy.deployJar(application, jarFile);
        } else if (className != null) {
            Deploy.deployService(application, className, publishPath);
        } else if (descriptorPath != null) {
            Deploy.deployDescriptor(application, descriptorPath, publishPath);
        } else {
            throw new IllegalArgumentException("unsupported combination of arguments");
        }
    }

    private static void deployJar(IApplication application, String jarPath) throws DeploymentException, FileNotFoundException {
        File jarFile = new File(jarPath);
        MIMEData jarAttachment = new MIMEData(jarFile);
        application.addJar(jarFile.getName(), jarAttachment);
    }

    private static void deployService(IApplication application, String className, String publishPath) throws DeploymentException {
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor(className, null, null, null);
        serviceDescriptor.publish = true;
        application.addServiceUsingDescriptor(publishPath, serviceDescriptor);
    }

    private static void deployDescriptor(IApplication application, String descriptorPath, String publishPath) throws DeploymentException, IOException {
        File descriptorFile = new File(descriptorPath);
        MIMEData descriptorAttachment = new MIMEData(descriptorFile);
        application.addService(publishPath, descriptorAttachment);
        descriptorAttachment.dispose();
    }
}

