/*
 * Decompiled with CFR 0.152.
 */
package electric.application;

import electric.application.IApplication;
import electric.directory.DirectoryException;
import electric.directory.IDirectory;
import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.Servers;
import electric.service.descriptor.ServiceDescriptor;
import electric.service.object.ObjectService;
import electric.util.XURL;
import electric.util.fileloader.IFileLoader;
import electric.util.resourceloader.ResourceLoaders;
import electric.xml.Element;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Application
implements IApplication,
IGLUELoggingConstants,
IGLUEContextConstants {
    private String appName;
    private IFileLoader fileLoader;
    private Element config;

    protected Application() {
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public IFileLoader getFileLoader() {
        return this.fileLoader;
    }

    public void setFileLoader(IFileLoader fileLoader) {
        this.fileLoader = fileLoader;
        ResourceLoaders.getFileResourceLoader().setFileLoader(fileLoader);
    }

    public Element getConfig() {
        return this.config;
    }

    public void setConfig(Element config) {
        this.config = config;
    }

    public void start() {
    }

    public void stop() {
    }

    public ServiceDescriptor getServiceDescriptor(String path) throws RegistryException {
        Object object = Registry.get(path);
        if (!(object instanceof ObjectService)) {
            return null;
        }
        return this.newServiceDescriptor((ObjectService)object, path);
    }

    private ServiceDescriptor newServiceDescriptor(ObjectService service, String path) {
        ServiceDescriptor descriptor = new ServiceDescriptor(service.getClassName(), null, null, null);
        descriptor.description = service.getDescription();
        descriptor.activation = service.getModeString();
        descriptor.targetNamespace = service.getWSDL().getTargetNamespace();
        descriptor.namespace = service.getContext().getStringProperty("namespace", "x");
        descriptor.soapAction = service.getContext().getStringProperty("soapAction", "varies per method");
        descriptor.style = service.getContext().getStringProperty("style", "rpc");
        descriptor.endpoint = Registry.getPath(service);
        Element element = new Element("urn");
        element.setText(path);
        descriptor.addExtensibilityElement(element);
        return descriptor;
    }

    public ServiceDescriptor[] getServiceDescriptors() throws RegistryException, DirectoryException {
        Vector vector = new Vector();
        this.addDescriptor(vector, "/", Registry.getDirectory("/"));
        Object[] descriptors = new ServiceDescriptor[vector.size()];
        vector.copyInto(descriptors);
        return descriptors;
    }

    private void addDescriptor(Vector vector, String root, IDirectory directory) throws RegistryException, DirectoryException {
        Enumeration keys = directory.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String path = root + key;
            Object object = Registry.get(path);
            if (object instanceof IDirectory) {
                this.addDescriptor(vector, path + "/", (IDirectory)object);
                continue;
            }
            if (!(object instanceof ObjectService)) continue;
            vector.addElement(this.newServiceDescriptor((ObjectService)object, path));
        }
    }

    public String[] getEndpoints() {
        XURL[] paths = Servers.getPaths();
        String[] endpoints = new String[paths.length];
        int i = 0;
        while (i < endpoints.length) {
            endpoints[i] = paths[i].toString();
            ++i;
        }
        return endpoints;
    }
}

