/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfigService;
import com.atlassian.plugins.authentication.impl.util.ApplicationStateValidator;
import com.atlassian.plugins.authentication.impl.web.saml.AssertionValidationService;
import com.atlassian.plugins.authentication.impl.web.saml.SessionData;
import com.atlassian.plugins.authentication.impl.web.saml.SessionDataService;
import com.atlassian.plugins.authentication.impl.web.saml.provider.InvalidSamlResponse;
import com.atlassian.plugins.authentication.impl.web.saml.provider.SamlProvider;
import com.atlassian.plugins.authentication.impl.web.saml.provider.SamlRequest;
import com.atlassian.plugins.authentication.impl.web.saml.provider.SamlResponse;
import com.atlassian.plugins.authentication.impl.web.usercontext.AuthenticationFailedException;
import com.atlassian.plugins.authentication.impl.web.usercontext.PrincipalResolver;
import com.atlassian.plugins.authentication.impl.web.usercontext.rememberme.RememberMeCookieHandler;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.security.Principal;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class SamlConsumerServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SamlConsumerServlet.class);
    public static final String URL = "/plugins/servlet/samlconsumer";
    public static final String SAML_RESPONSE_PARAM = "SAMLResponse";
    public static final String RELAY_STATE_QUERY_PARAM = "RelayState";
    private final ApplicationProperties applicationProperties;
    private final SamlConfigService samlConfigService;
    private final PrincipalResolver principalResolver;
    private final SamlProvider samlProvider;
    private final SessionDataService sessionDataService;
    private final AssertionValidationService assertionValidationService;
    private final AuthenticationListener authenticationListener;
    private final I18nResolver i18nResolver;
    private final RememberMeCookieHandler rememberMeCookieHandler;
    private final ApplicationStateValidator applicationStateValidator;

    @Inject
    public SamlConsumerServlet(@ComponentImport ApplicationProperties applicationProperties, SamlConfigService samlConfigService, PrincipalResolver principalResolver, SamlProvider samlProvider, SessionDataService sessionDataService, AssertionValidationService assertionValidationService, @ComponentImport AuthenticationListener authenticationListener, @ComponentImport I18nResolver i18nResolver, RememberMeCookieHandler rememberMeCookieHandler, ApplicationStateValidator applicationStateValidator) {
        this.applicationProperties = applicationProperties;
        this.samlConfigService = samlConfigService;
        this.principalResolver = principalResolver;
        this.samlProvider = samlProvider;
        this.sessionDataService = sessionDataService;
        this.assertionValidationService = assertionValidationService;
        this.rememberMeCookieHandler = rememberMeCookieHandler;
        this.authenticationListener = authenticationListener;
        this.i18nResolver = i18nResolver;
        this.applicationStateValidator = applicationStateValidator;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Received SAML POST payload");
        this.applicationStateValidator.checkCanConsumeSaml();
        Optional<SessionData> sessionData = this.sessionDataService.getSessionData(request, response, request.getParameter(RELAY_STATE_QUERY_PARAM));
        Optional<SamlRequest> samlRequest = sessionData.map(SessionData::getSamlRequest);
        String targetUrl = this.extractTargetUrlOrReturnBaseUrl(sessionData);
        String username = null;
        try {
            SamlResponse samlResponse = this.samlProvider.extractSamlResponse(request, response, samlRequest.orElse(null));
            this.assertionValidationService.validateAssertionId(samlResponse);
            username = this.getUsernameAttribute(samlResponse, this.samlConfigService.getSamlConfig());
            log.debug("Extracted username {} from valid SAML request", (Object)username);
            Principal principal = this.principalResolver.resolvePrincipal(username, request);
            log.debug("Authenticated user {}, redirecting to {}", (Object)username, (Object)targetUrl);
            this.sessionDataService.requireNewSession(request);
            this.sessionDataService.setUserLoggedInWithSaml(request);
            this.authenticationListener.authenticationSuccess((Authenticator.Result)new Authenticator.Result.Success(this.i18nResolver.createMessage("saml.authentication.successful", new Serializable[]{username}), principal), request, response);
            this.refreshRememberMeCookieIfNeeded(request, response, principal);
            this.productSpecificWorkarounds(request);
            response.sendRedirect(targetUrl);
        }
        catch (InvalidSamlResponse e) {
            e.setTargetUrl(sessionData.flatMap(SessionData::getTargetUrl).map(URI::toString).orElse(null));
            this.authenticationListener.authenticationFailure((Authenticator.Result)new Authenticator.Result.Failure(this.i18nResolver.createMessage("saml.authentication.invalidsamlresponse", new Serializable[]{request.getRemoteAddr()})), request, response);
            throw e;
        }
        catch (AuthenticationFailedException e) {
            this.authenticationListener.authenticationFailure((Authenticator.Result)new Authenticator.Result.Failure(this.i18nResolver.createMessage("saml.authentication.authenticationfailed", new Serializable[]{username})), request, response);
            throw e;
        }
    }

    private String extractTargetUrlOrReturnBaseUrl(Optional<SessionData> sessionData) {
        String targetUrl = sessionData.flatMap(SessionData::getTargetUrl).map(uri -> UriBuilder.fromUri((URI)uri).replacePath("").path(this.applicationProperties.getBaseUrl(UrlMode.RELATIVE)).path(uri.getPath()).build(new Object[0]).toString()).orElse(this.applicationProperties.getBaseUrl(UrlMode.RELATIVE));
        if (targetUrl.isEmpty()) {
            targetUrl = "/";
        }
        return targetUrl;
    }

    private void refreshRememberMeCookieIfNeeded(HttpServletRequest request, HttpServletResponse response, Principal principal) {
        if (this.samlConfigService.getSamlConfig().isEnableRememberMe()) {
            this.rememberMeCookieHandler.refreshRememberMeCookie(request, response, principal);
        }
    }

    private void productSpecificWorkarounds(HttpServletRequest request) {
        if ("jira".equals(this.applicationProperties.getPlatformId())) {
            request.setAttribute("com.atlassian.web.servlet.plugin.request.RedirectInterceptingResponse.sendRedirect", (Object)Boolean.TRUE);
            request.getSession().setAttribute("com.atlassian.labs.botkiller.BotKiller", (Object)request.getSession().getMaxInactiveInterval());
        }
    }

    private String getUsernameAttribute(SamlResponse samlResponse, SamlConfig samlConfig) {
        if (samlConfig.getUsernameAttribute() != null) {
            return (String)Iterables.getOnlyElement(samlResponse.getAttribute(samlConfig.getUsernameAttribute()));
        }
        return samlResponse.getNameId();
    }
}

