/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.saml;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfigService;
import com.atlassian.plugins.authentication.impl.util.ApplicationStateValidator;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandler;
import com.atlassian.plugins.authentication.impl.web.saml.SessionData;
import com.atlassian.plugins.authentication.impl.web.saml.SessionDataService;
import com.atlassian.plugins.authentication.impl.web.saml.provider.SamlProvider;
import com.atlassian.plugins.authentication.impl.web.saml.provider.SamlRequest;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SamlAuthenticationHandler
implements AuthenticationHandler {
    public static final int COOKIE_WITH_FRAGMENT_MAXIMUM_AGE = 5;
    private static final Logger log = LoggerFactory.getLogger(SamlAuthenticationHandler.class);
    private final SamlProvider samlProvider;
    private final SessionDataService sessionDataService;
    private final ApplicationStateValidator applicationStateValidator;
    private final SamlConfigService samlConfigService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final ApplicationProperties applicationProperties;

    @Inject
    public SamlAuthenticationHandler(SamlProvider samlProvider, SamlConfigService samlConfigService, SessionDataService sessionDataService, ApplicationStateValidator applicationStateValidator, SoyTemplateRenderer soyTemplateRenderer, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport ApplicationProperties applicationProperties) {
        this.samlProvider = samlProvider;
        this.samlConfigService = samlConfigService;
        this.sessionDataService = sessionDataService;
        this.applicationStateValidator = applicationStateValidator;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void processAuthenticationRequest(HttpServletRequest request, HttpServletResponse response, @Nullable URI destinationUri) throws IOException {
        this.applicationStateValidator.checkCanProcessAuthenticationRequest();
        this.sessionDataService.ensureSessionExists(request);
        String relayState = UUID.randomUUID().toString();
        SamlRequest samlRequest = this.samlProvider.createSamlSingleSignOnRequest(request, response, relayState, this.isPermissionViolation(request));
        this.sessionDataService.setSessionData(request, relayState, new SessionData(samlRequest, destinationUri));
        if (destinationUri != null) {
            this.renderFragmentSavingPage(response, samlRequest);
        } else {
            response.sendRedirect(samlRequest.getLoginRequestUrl());
        }
    }

    private void renderFragmentSavingPage(HttpServletResponse resp, SamlRequest samlRequest) throws IOException {
        resp.setContentType("text/html");
        resp.setCharacterEncoding("utf-8");
        this.soyTemplateRenderer.render((Appendable)resp.getWriter(), "com.atlassian.plugins.authentication.atlassian-authentication-plugin:save-fragment", "AuthenticationPlugin.SaveHash.display", (Map)ImmutableMap.of((Object)"idpRequest", (Object)samlRequest.getLoginRequestUrl(), (Object)"cookieName", (Object)("atlassian-authentication-plugin-url-fragment_" + samlRequest.getRelayState()), (Object)"cookiePath", (Object)this.applicationProperties.getBaseUrl(com.atlassian.sal.api.UrlMode.RELATIVE), (Object)"cookieExpirationTimeInMinutesFromNow", (Object)5, (Object)"jsCookieLibraryUrl", (Object)this.webResourceUrlProvider.getStaticPluginResourceUrl("com.atlassian.plugins.authentication.atlassian-authentication-plugin:save-fragment", "js.cookie.js", UrlMode.RELATIVE)));
    }

    private boolean isPermissionViolation(HttpServletRequest request) {
        if (this.sessionDataService.isUserLoggedInWithSaml(request)) {
            log.info("User is already logged in. Looks like permissions violation. Force re-authentication in IDP");
            return true;
        }
        return false;
    }

    @Override
    public boolean isConfigured() {
        return this.samlConfigService.getSamlConfig().isConfigured();
    }
}

