/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.filter.logout;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfigService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Scanned
public class LogoutFilter
implements Filter {
    protected final ApplicationProperties applicationProperties;
    protected final SamlConfigService samlConfigService;

    public LogoutFilter(@ComponentImport ApplicationProperties applicationProperties, SamlConfigService samlConfigService) {
        this.applicationProperties = applicationProperties;
        this.samlConfigService = samlConfigService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.samlConfigService.getSamlConfig().isRedirectOnLogin() && this.shouldRequestBeRedirected((HttpServletRequest)request)) {
            this.redirectToSamlLogoutPage((HttpServletRequest)request, (HttpServletResponse)response);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected boolean shouldRequestBeRedirected(HttpServletRequest request) {
        return true;
    }

    protected void redirectToSamlLogoutPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/plugins/servlet/saml-logout");
    }

    public void destroy() {
    }
}

