/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config.saml;

import com.atlassian.plugins.authentication.impl.config.saml.ErrorReason;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.config.saml.ValidationUtils;
import com.atlassian.plugins.authentication.impl.util.HttpsValidator;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URL;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;

@Named
public class SamlConfigValidator {
    private final HttpsValidator httpsValidator;

    @Inject
    public SamlConfigValidator(HttpsValidator httpsValidator) {
        this.httpsValidator = httpsValidator;
    }

    public Multimap<String, ErrorReason> validate(SamlConfig samlConfigModel) {
        HashMultimap errorsOnField = HashMultimap.create();
        errorsOnField.putAll((Object)"sso-url", this.validateRequiredField(samlConfigModel.getIdpSsoUrl()));
        errorsOnField.putAll((Object)"sso-issuer", this.validateRequiredField(samlConfigModel.getSsoIssuer()));
        errorsOnField.putAll((Object)"certificate", this.validateRequiredField(samlConfigModel.getCertificate()));
        errorsOnField.putAll((Object)"sso-url", this.validateSsoUrl(samlConfigModel.getIdpSsoUrl()));
        errorsOnField.putAll((Object)"certificate", this.validateCertificate(samlConfigModel.getCertificate()));
        return ImmutableMultimap.copyOf((Multimap)errorsOnField);
    }

    private Iterable<ErrorReason> validateRequiredField(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return Collections.singleton(ErrorReason.REQUIRED);
        }
        return Collections.emptyList();
    }

    private Iterable<ErrorReason> validateCertificate(String certificateString) {
        if (!Strings.nullToEmpty((String)certificateString).isEmpty()) {
            try {
                ValidationUtils.convertToCertificate(certificateString);
            }
            catch (Exception e) {
                return Collections.singleton(ErrorReason.INCORRECT);
            }
        }
        return Collections.emptyList();
    }

    private Iterable<ErrorReason> validateSsoUrl(String ssoUrl) {
        if (!Strings.isNullOrEmpty((String)ssoUrl)) {
            if (!this.validateUrl(ssoUrl)) {
                return Collections.singleton(ErrorReason.INCORRECT);
            }
            if (!this.validateUrlIsSecure(ssoUrl)) {
                return Collections.singleton(ErrorReason.INSECURE);
            }
        }
        return Collections.emptyList();
    }

    private boolean validateUrlIsSecure(String ssoUrl) {
        URL url;
        return !this.httpsValidator.isHttpsRequired() || Strings.isNullOrEmpty((String)ssoUrl) || (url = ValidationUtils.convertToUrl(ssoUrl)) == null || "https".equalsIgnoreCase(url.getProtocol());
    }

    private boolean validateUrl(String urlString) {
        if (!Strings.isNullOrEmpty((String)urlString)) {
            try {
                ValidationUtils.convertToUrl(urlString);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }
}

