/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.atlassian.plugins.authentication.event.saml.SamlDisabledEvent;
import com.atlassian.plugins.authentication.event.saml.SamlEnabledEvent;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfigService;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
public class JIRALoginGadgetDisabler {
    private static final Logger logger = LoggerFactory.getLogger(JIRALoginGadgetDisabler.class);
    private final EventPublisher eventPublisher;
    private final ApplicationProperties jiraApplicationProperties;
    private final SamlConfigService samlConfigService;
    private final PluginSettingsFactory pluginSettings;
    public static final String PREFIX = "com.atlassian.plugins.authentication.samlconfig.";
    public static final String LOGIN_GADGET_INITIALLY_DISABLED = "jira.login.gadget.initially.disabled";

    @Inject
    public JIRALoginGadgetDisabler(@ComponentImport EventPublisher eventPublisher, @JiraImport(value="jiraApplicationProperties") ApplicationProperties jiraApplicationProperties, SamlConfigService samlConfigService, @ComponentImport PluginSettingsFactory pluginSettings) {
        this.eventPublisher = eventPublisher;
        this.jiraApplicationProperties = jiraApplicationProperties;
        this.samlConfigService = samlConfigService;
        this.pluginSettings = pluginSettings;
    }

    @PostConstruct
    public void setup() {
        this.eventPublisher.register((Object)this);
        this.disableLoginGadget();
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onSamlEnabledEvent(SamlEnabledEvent event) {
        if (event.isSamlLoginMandatory()) {
            this.disableLoginGadget();
        } else {
            this.restoreLoginGadgetInitialState();
        }
    }

    @EventListener
    public void onSamlDisabledEvent(SamlDisabledEvent event) {
        this.restoreLoginGadgetInitialState();
    }

    private Object setBooleanValue(String key, boolean value) {
        return this.settings().put(PREFIX + key, (Object)String.valueOf(value));
    }

    private Optional<Boolean> getBooleanValue(String key) {
        String value = (String)this.settings().get(PREFIX + key);
        return value == null ? Optional.empty() : Optional.of(Boolean.valueOf(value));
    }

    private PluginSettings settings() {
        return this.pluginSettings.createGlobalSettings();
    }

    private void disableLoginGadget() {
        if (this.samlConfigService.getSamlConfig().isConfigured()) {
            boolean loginGadgetInitiallyDisabled = this.getBooleanValue(LOGIN_GADGET_INITIALLY_DISABLED).orElse(this.jiraApplicationProperties.getOption("jira.disable.login.gadget"));
            this.setBooleanValue(LOGIN_GADGET_INITIALLY_DISABLED, loginGadgetInitiallyDisabled);
            this.jiraApplicationProperties.setOption("jira.disable.login.gadget", true);
            logger.info("Disabled login gadget. Initial state was: {}", (Object)(loginGadgetInitiallyDisabled ? "disabled" : "enabled"));
        }
    }

    private void restoreLoginGadgetInitialState() {
        this.getBooleanValue(LOGIN_GADGET_INITIALLY_DISABLED).ifPresent(loginGadgetInitiallyDisabled -> {
            this.jiraApplicationProperties.setOption("jira.disable.login.gadget", loginGadgetInitiallyDisabled.booleanValue());
            logger.info("Restored login gadget state to: {}", (Object)(loginGadgetInitiallyDisabled != false ? "disabled" : "enabled"));
        });
        this.settings().remove("com.atlassian.plugins.authentication.samlconfig.jira.login.gadget.initially.disabled");
    }
}

