/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gzipfilter.selector;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PatternMatcher {
    private final Map patternCache = Collections.synchronizedMap(new HashMap());

    public boolean matches(String contentType, String mimeTypesToGzip) {
        String[] mimeTypes = StringUtils.split((String)mimeTypesToGzip, (String)",");
        for (int i = 0; i < mimeTypes.length; ++i) {
            String mimeType = mimeTypes[i].trim();
            Pattern p = (Pattern)this.patternCache.get(mimeType);
            if (p == null) {
                p = Pattern.compile(mimeType);
                this.patternCache.put(mimeType, p);
            }
            if (!p.matcher(contentType).matches()) continue;
            return true;
        }
        return false;
    }
}

