/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.quicksearch.rest;

import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.plugins.quicksearch.api.ConcurrentQueryCounterInstrument;
import com.atlassian.jira.plugins.quicksearch.api.QueryLimiter;
import com.atlassian.jira.plugins.quicksearch.api.ResultGroup;
import com.atlassian.jira.plugins.quicksearch.impl.AnalyticsHelper;
import com.atlassian.jira.plugins.quicksearch.impl.ProductSearchService;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="productsearch")
@AnonymousAllowed
@Produces(value={"application/json"})
public class ProductSearchResource {
    public static final Response QUOTA_EXCEEDED_RESPONSE = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    private final Logger LOGGER = LoggerFactory.getLogger(ProductSearchResource.class);
    private final ProductSearchService productSearchService;
    private final QueryLimiter queryLimiter;
    private final AnalyticsHelper analyticsHelper;

    @Autowired
    public ProductSearchResource(ProductSearchService productSearchService, QueryLimiter queryLimiter, AnalyticsHelper analyticsHelper) {
        this.productSearchService = productSearchService;
        this.queryLimiter = queryLimiter;
        this.analyticsHelper = analyticsHelper;
    }

    @GET
    @Path(value="/search")
    public Response query(@QueryParam(value="q") @DefaultValue(value="") String query, @QueryParam(value="type") @DefaultValue(value="all") TypeParameter types) {
        ConcurrentQueryCounterInstrument<QueryLimiter.QueryResponse> instrumentation = new ConcurrentQueryCounterInstrument<QueryLimiter.QueryResponse>(InstrumentationName.QUICKSEARCH_CONCURRENT_REQUESTS);
        QueryLimiter.QueryResponse response = instrumentation.execute(() -> this.getLimitedResponse(query, types));
        this.analyticsHelper.sendAnalytics(query, response);
        return response.getResponse();
    }

    private QueryLimiter.QueryResponse getLimitedResponse(String query, TypeParameter types) {
        return this.queryLimiter.getResponseWithLimit(() -> this.getResponse(query, types), QUOTA_EXCEEDED_RESPONSE);
    }

    private Response getResponse(String query, TypeParameter types) {
        try {
            if (!this.productSearchService.canSupportSearchTypes(types.getTypes())) {
                this.LOGGER.debug("Invalid parameter for types, returning bad request");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (StringUtils.isBlank((String)query)) {
                return this.getUserRecentItems(types);
            }
            return Response.ok(this.productSearchService.search(query, types.getTypes())).build();
        }
        catch (Exception e) {
            this.LOGGER.error("Error in product search endpoint", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Response getUserRecentItems(TypeParameter types) throws Exception {
        List<ResultGroup> results = this.productSearchService.getRecent(types.getTypes());
        return Response.ok(results).build();
    }

    private class PerformanceAnalytics {
        long start = System.currentTimeMillis();
        long end;

        public void end() {
            this.end = System.currentTimeMillis();
        }

        public long getDuration() {
            return this.end - this.start;
        }

        public void sendAnalytics() {
        }
    }

    public static class TypeParameter {
        private final List<String> types;

        public TypeParameter(String typesParam) {
            this.types = StringUtils.isBlank((String)typesParam) ? Collections.emptyList() : Arrays.asList(typesParam.split(","));
        }

        List<String> getTypes() {
            return this.types;
        }
    }
}

