/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.quicksearch.impl;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.plugins.quicksearch.api.ProductSearcher;
import com.atlassian.jira.plugins.quicksearch.api.ResultGroup;
import com.atlassian.jira.plugins.quicksearch.api.ResultItem;
import com.atlassian.jira.plugins.quicksearch.impl.ProjectKeyHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeyFormatter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectSearcher
implements ProductSearcher {
    public static final String PROJECTS_GROUP_ID = "quick-search-projects";
    private static final String PROJECTS_BROWSE_PATH = "/projects";
    private static final String PROJECT_VIEW_PATH = "/browse/";
    private static final String PROJECTS_NAME_I18N_KEY = "ultimate.search.group.projects.name";
    private static final String PROJECTS_VIEW_ALL_I18N_KEY = "ultimate.search.group.projects.viewall";
    private static final String PROJECTS_VIEW_ALL_MATCHING_I18N_KEY = "ultimate.search.group.projects.viewall.matching";
    private static final String SEARCH_TYPE_LABEL = "projects";
    private static final int MAX_PROJECTS_COUNT = 2;
    private final JiraBaseUrls jiraBaseUrls;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserProjectHistoryManager userProjectHistoryManager;
    private final AvatarService avatarService;
    private final ProjectService projectService;
    private final ProjectKeyHelper projectKeyHelper;

    @Autowired
    ProjectSearcher(@ComponentImport JiraBaseUrls jiraBaseUrls, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport UserProjectHistoryManager userProjectHistoryManager, @ComponentImport AvatarService avatarService, @ComponentImport ProjectService projectService, ProjectKeyHelper projectKeyHelper) {
        this.jiraBaseUrls = jiraBaseUrls;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userProjectHistoryManager = userProjectHistoryManager;
        this.avatarService = avatarService;
        this.projectService = projectService;
        this.projectKeyHelper = projectKeyHelper;
    }

    @Override
    public ResultGroup getRecentItems() {
        return this.getRecentItems(2);
    }

    @Override
    public ResultGroup getRecentItems(int maxItemCount) {
        List<ResultItem> resultItems = this.userProjectHistoryManager.getProjectHistoryWithPermissionChecks(ProjectAction.VIEW_ISSUES, this.jiraAuthenticationContext.getLoggedInUser()).stream().limit(maxItemCount).map(this::toResultItem).collect(Collectors.toList());
        return this.buildResultGroupForRecentProjects(resultItems);
    }

    @Override
    public ResultGroup getSearchedItems(@Nonnull String search) throws Exception {
        return this.getSearchedItems(2, search);
    }

    @Override
    public ResultGroup getSearchedItems(int maximumItemCount, @Nonnull String search) throws Exception {
        Preconditions.checkNotNull((Object)search);
        List matchingRecentProjects = this.userProjectHistoryManager.getProjectHistoryWithPermissionChecks(ProjectAction.VIEW_ISSUES, this.jiraAuthenticationContext.getLoggedInUser()).stream().filter(p -> this.matchesSearch((Project)p, search)).limit(maximumItemCount).collect(Collectors.toList());
        List<ResultItem> results = matchingRecentProjects.stream().map(this::toResultItem).collect(Collectors.toList());
        if (results.size() < maximumItemCount) {
            Comparator projectComparator = (p1, p2) -> p1.getName().compareToIgnoreCase(p2.getName());
            List matchingProjects = ((List)this.projectService.getAllProjectsForAction(this.jiraAuthenticationContext.getLoggedInUser(), ProjectAction.VIEW_ISSUES).get()).stream().filter(p -> !matchingRecentProjects.contains(p)).filter(p -> this.matchesSearch((Project)p, search)).sorted(projectComparator).limit(maximumItemCount - matchingRecentProjects.size()).map(this::toResultItem).collect(Collectors.toList());
            results.addAll(matchingProjects);
        }
        if (results.isEmpty()) {
            return this.buildResultGroup(results, "", PROJECTS_VIEW_ALL_I18N_KEY);
        }
        return this.buildResultGroup(results, search, PROJECTS_VIEW_ALL_MATCHING_I18N_KEY);
    }

    @Override
    public String getSearchTypeLabel() {
        return SEARCH_TYPE_LABEL;
    }

    private ResultItem toResultItem(Project project) {
        URI url = new UrlBuilder(this.jiraBaseUrls.baseUrl()).addPath(PROJECT_VIEW_PATH).addPath(project.getKey()).asURI();
        URI avatarUrl = this.avatarService.getProjectAvatarAbsoluteURL(project, Avatar.Size.MEDIUM);
        String title = this.getProjectTitle(project);
        String subtitle = ProjectTypeKeyFormatter.format((ProjectTypeKey)project.getProjectTypeKey());
        return new ResultItem(title, subtitle, avatarUrl, url);
    }

    private String getProjectTitle(Project project) {
        return project.getName() + " (" + project.getKey() + ")";
    }

    private ResultGroup buildResultGroup(List<ResultItem> resultItems, String query, String i18nViewAllKey) {
        I18nHelper i18nHelper = this.jiraAuthenticationContext.getI18nHelper();
        URI uri = new UrlBuilder(this.jiraBaseUrls.baseUrl()).addPath(PROJECTS_BROWSE_PATH).addParameter("selectedCategory", "all").addParameter("selectedProjectType", "all").addParameter("contains", query).asURI();
        return new ResultGroup(PROJECTS_GROUP_ID, i18nHelper.getText(PROJECTS_NAME_I18N_KEY), uri, i18nHelper.getText(i18nViewAllKey), resultItems);
    }

    private ResultGroup buildResultGroupForRecentProjects(List<ResultItem> resultItems) {
        return this.buildResultGroup(resultItems, "", PROJECTS_VIEW_ALL_I18N_KEY);
    }

    private boolean matchesSearch(Project project, String search) {
        Pattern searchPattern = Pattern.compile(Pattern.quote(search), 66);
        boolean matchesName = searchPattern.matcher(project.getName()).find();
        boolean matchesKey = searchPattern.matcher(project.getKey()).find();
        boolean matchesIssueKey = this.extractProjectKey(search).orElse("").toUpperCase().equals(project.getKey());
        return matchesName || matchesKey || matchesIssueKey;
    }

    private Optional<String> extractProjectKey(String query) {
        return Optional.ofNullable(this.projectKeyHelper.getIssueKeyPattern().map(p -> p.matcher(query)).filter(matcher -> matcher.find()).map(this.projectKeyHelper::getProjectKey).orElse(null));
    }
}

