/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.quicksearch.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProjectKeyHelper {
    private final Logger LOGGER = LoggerFactory.getLogger(ProjectKeyHelper.class);
    private final ApplicationProperties applicationProperties;
    private static final String PATTERN_TEMPLATE = "(?<issuekey>(?<projectkey>%s)[-](?<issuenumber>\\d*))(\\s|$)";
    private static final String ISSUE_KEY_GROUP = "issuekey";
    private static final String PROJECT_KEY_GROUP = "projectkey";
    private static final String ISSUE_NUMBER_GROUP = "issuenumber";
    private Pattern issueKeyPattern;

    public ProjectKeyHelper(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public synchronized Optional<Pattern> getIssueKeyPattern() {
        String issueKeyPatternString = this.getIssueKeyPatternString();
        if (this.issueKeyPattern == null || !this.issueKeyPattern.pattern().equals(issueKeyPatternString)) {
            try {
                this.issueKeyPattern = Pattern.compile(issueKeyPatternString, 2);
            }
            catch (Exception e) {
                this.LOGGER.warn("Exception during parsing issue key pattern {}", (Object)issueKeyPatternString);
                this.issueKeyPattern = null;
            }
        }
        return Optional.ofNullable(this.issueKeyPattern);
    }

    public String getIssueKey(Matcher matcher) {
        return matcher.group(ISSUE_KEY_GROUP);
    }

    public String getProjectKey(Matcher matcher) {
        return matcher.group(PROJECT_KEY_GROUP);
    }

    public String getIssueNumber(Matcher matcher) {
        return matcher.group(ISSUE_NUMBER_GROUP);
    }

    private String getIssueKeyPatternString() {
        return String.format(PATTERN_TEMPLATE, this.applicationProperties.getDefaultBackedString("jira.projectkey.pattern"));
    }
}

