/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.quicksearch.impl;

import com.atlassian.jira.util.collect.CollectionBuilder;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class ProductSearchTextUtils {
    private static final String TEXT_SEARCH_WILDCARD = "*";
    private static final Set<Character> RESERVED_LUCENE_OPERATORS = CollectionBuilder.newBuilder((Object[])new Character[]{Character.valueOf('+'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('!'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf(':'), Character.valueOf('\"'), Character.valueOf('\"'), Character.valueOf('\\')}).asSet();

    ProductSearchTextUtils() {
    }

    private static String sanitiseForLucene(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return input;
        }
        String stripped = input.chars().mapToObj(i -> Character.valueOf((char)i)).map(c -> RESERVED_LUCENE_OPERATORS.contains(c) ? " " : c.toString()).collect(Collectors.joining());
        return Arrays.stream(stripped.split(" ")).map(word -> StringUtils.strip((String)word, (String)"-")).map(word -> word.replaceAll("-", "\\\\-")).collect(Collectors.joining(" "));
    }

    static String createWildcardLuceneQuery(String input) {
        String strippedQuery = ProductSearchTextUtils.sanitiseForLucene(input);
        if (StringUtils.isBlank((CharSequence)strippedQuery)) {
            return strippedQuery;
        }
        return strippedQuery.trim().concat(TEXT_SEARCH_WILDCARD);
    }
}

