/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.quicksearch.impl;

import com.atlassian.jira.plugins.quicksearch.api.ProductSearcher;
import com.atlassian.jira.plugins.quicksearch.api.ResultGroup;
import com.atlassian.jira.plugins.quicksearch.impl.IssueSearcher;
import com.atlassian.jira.plugins.quicksearch.impl.ProjectSearcher;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductSearchService {
    private static final String ALL_TYPES_LABEL = "all";
    private static final int MAX_ITEM_COUNT = 10;
    private final IssueSearcher issueSearcher;
    private final ProjectSearcher projectSearcher;

    @Autowired
    public ProductSearchService(IssueSearcher issueSearcher, ProjectSearcher projectSearcher) {
        this.issueSearcher = issueSearcher;
        this.projectSearcher = projectSearcher;
    }

    public List<ResultGroup> search(String query, List<String> searchTypes) throws Exception {
        return this.process(query, searchTypes);
    }

    public List<ResultGroup> getRecent(List<String> searchTypes) throws Exception {
        return this.process("", searchTypes);
    }

    private List<ResultGroup> process(String query, List<String> searchTypes) throws Exception {
        boolean isSearchingAll = searchTypes.contains(ALL_TYPES_LABEL);
        boolean isSearch = !StringUtils.isBlank((String)query);
        List<ResultGroup> result = this.getSearchersWithoutIssueSearcher().stream().filter(searcher -> isSearchingAll || searchTypes.contains(searcher.getSearchTypeLabel())).map(searcher -> {
            try {
                return isSearch ? searcher.getSearchedItems(query) : searcher.getRecentItems();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        int totalCountWithoutIssues = 0;
        for (ResultGroup group : result) {
            totalCountWithoutIssues += group.getItems().size();
        }
        ProductSearcher issueSearcher = this.getIssueSearcher();
        if (isSearchingAll || searchTypes.contains(issueSearcher.getSearchTypeLabel())) {
            ResultGroup issuesResultGroup = isSearch ? issueSearcher.getSearchedItems(10 - totalCountWithoutIssues, query) : issueSearcher.getRecentItems(10 - totalCountWithoutIssues);
            result.add(0, issuesResultGroup);
        }
        return result;
    }

    public boolean canSupportSearchTypes(List<String> requestedTypes) {
        if (requestedTypes.contains(ALL_TYPES_LABEL)) {
            return true;
        }
        List supportedTypes = this.getSearchers().stream().map(ProductSearcher::getSearchTypeLabel).collect(Collectors.toList());
        return !requestedTypes.isEmpty() && supportedTypes.containsAll(requestedTypes);
    }

    private List<ProductSearcher> getSearchers() {
        ArrayList<ProductSearcher> result = new ArrayList<ProductSearcher>(this.getSearchersWithoutIssueSearcher());
        result.add(this.getIssueSearcher());
        return result;
    }

    private ProductSearcher getIssueSearcher() {
        return this.issueSearcher;
    }

    private List<ProductSearcher> getSearchersWithoutIssueSearcher() {
        return ImmutableList.of((Object)this.projectSearcher);
    }
}

