/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.quicksearch.impl;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.util.PermissionFilterCachedSearchProvider;
import com.atlassian.jira.plugins.quicksearch.api.ProductSearcher;
import com.atlassian.jira.plugins.quicksearch.api.ResultGroup;
import com.atlassian.jira.plugins.quicksearch.api.ResultItem;
import com.atlassian.jira.plugins.quicksearch.impl.IssueSearchQuery;
import com.atlassian.jira.plugins.quicksearch.impl.ProjectKeyHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueSearcher
implements ProductSearcher {
    public static final String ISSUES_GROUP_ID = "quick-search-issues";
    private static final String ISSUES_NAME_I18N_KEY = "ultimate.search.group.issues.name";
    private static final String ISSUES_VIEW_ALL_I18N_KEY = "ultimate.search.group.issues.viewall";
    private static final String ISSUES_VIEW_ALL_MATCHING_I18N_KEY = "ultimate.search.group.issues.viewall.matching";
    private static final String RECENT_ISSUES_JQL = "order by lastViewed DESC";
    private static final String ISSUES_PATH = "/issues/";
    private static final String ISSUE_VIEW_PATH = "/browse/";
    private static final String JQL_PARAMETER = "jql";
    private static final String SEARCH_TYPE_LABEL = "issues";
    public static final int MAXIMUM_NUMBER_OF_ISSUES = 10;
    private final JiraBaseUrls jiraBaseUrls;
    private final UserIssueHistoryManager userIssueHistoryManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SearchService searchService;
    private final PermissionFilterCachedSearchProvider searchProvider;
    private final ProjectKeyHelper projectKeyHelper;

    @Autowired
    IssueSearcher(@ComponentImport JiraBaseUrls jiraBaseUrls, @ComponentImport UserIssueHistoryManager userIssueHistoryManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport SearchService searchService, @ComponentImport PermissionFilterCachedSearchProvider searchProvider, ProjectKeyHelper projectKeyHelper) {
        this.jiraBaseUrls = jiraBaseUrls;
        this.userIssueHistoryManager = userIssueHistoryManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.searchService = searchService;
        this.searchProvider = searchProvider;
        this.projectKeyHelper = projectKeyHelper;
    }

    @Override
    public ResultGroup getRecentItems() {
        return this.getRecentItems(10);
    }

    @Override
    public ResultGroup getRecentItems(int maxItemCount) {
        List<ResultItem> resultItems = this.userIssueHistoryManager.getShortIssueHistory(this.jiraAuthenticationContext.getLoggedInUser()).stream().limit(maxItemCount).map(this::toResultItem).collect(Collectors.toList());
        return this.buildResultGroup(resultItems, RECENT_ISSUES_JQL, ISSUES_VIEW_ALL_I18N_KEY);
    }

    @Override
    public ResultGroup getSearchedItems(@Nonnull String search) throws SearchException {
        return this.getSearchedItems(10, search);
    }

    @Override
    public ResultGroup getSearchedItems(int maxItemCount, @Nonnull String search) throws SearchException {
        Preconditions.checkNotNull((Object)search);
        IssueSearchQuery issueSearch = new IssueSearchQuery(this.jiraAuthenticationContext, this.searchProvider, this.projectKeyHelper, maxItemCount).build(search);
        List<ResultItem> resultItems = issueSearch.getResults().stream().map(this::toResultItem).collect(Collectors.toList());
        String viewAllKey = resultItems.isEmpty() ? ISSUES_VIEW_ALL_I18N_KEY : ISSUES_VIEW_ALL_MATCHING_I18N_KEY;
        return this.buildResultGroup(resultItems, this.searchService.getGeneratedJqlString(issueSearch.getViewAllQuery()), viewAllKey);
    }

    @Override
    public String getSearchTypeLabel() {
        return SEARCH_TYPE_LABEL;
    }

    private ResultGroup buildResultGroup(List<ResultItem> resultItems, String jql, String viewAllTextKey) {
        I18nHelper i18nHelper = this.jiraAuthenticationContext.getI18nHelper();
        URI uri = new UrlBuilder(this.jiraBaseUrls.baseUrl()).addPath(ISSUES_PATH).addParameter(JQL_PARAMETER, jql).asURI();
        return new ResultGroup(ISSUES_GROUP_ID, i18nHelper.getText(ISSUES_NAME_I18N_KEY), uri, i18nHelper.getText(viewAllTextKey), resultItems);
    }

    private ResultItem toResultItem(Issue issue) {
        boolean hasIconUrl = issue.getIssueType() != null && issue.getIssueType().getCompleteIconUrl() != null;
        URI iconUrl = hasIconUrl ? new UrlBuilder(issue.getIssueType().getCompleteIconUrl()).asURI() : null;
        URI url = new UrlBuilder(this.jiraBaseUrls.baseUrl()).addPath(ISSUE_VIEW_PATH).addPath(issue.getKey()).asURI();
        return new ResultItem(issue.getSummary(), issue.getKey(), iconUrl, url);
    }
}

