/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.quicksearch.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.util.PermissionFilterCachedSearchProvider;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugins.quicksearch.impl.ProductSearchTextUtils;
import com.atlassian.jira.plugins.quicksearch.impl.ProjectKeyHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

class IssueSearchQuery {
    private static final String LAST_VIEWED_FIELD = "lastViewed";
    private String originalQuery;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionFilterCachedSearchProvider searchProvider;
    private final ProjectKeyHelper projectKeyHelper;
    private final int maximumItemCount;
    private String issueKey;
    private String issueKeyRefinementQuery;
    private boolean hasWholeIssueKey;
    private List<Issue> results;
    private Query viewAllQuery;

    IssueSearchQuery(JiraAuthenticationContext jiraAuthenticationContext, PermissionFilterCachedSearchProvider searchProvider, ProjectKeyHelper projectKeyHelper, int maximumItemCount) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.searchProvider = searchProvider;
        this.projectKeyHelper = projectKeyHelper;
        this.maximumItemCount = maximumItemCount;
        this.results = new ArrayList<Issue>();
    }

    IssueSearchQuery build(String query) throws SearchException {
        if (this.viewAllQuery != null) {
            throw new IllegalStateException("Not in a clean state. Issue search already built.");
        }
        this.originalQuery = query;
        this.extractIssueKey();
        this.searchIssueKeyRange();
        if (this.needsMoreResults()) {
            this.searchSummaryDescription();
        }
        if (this.viewAllQuery == null) {
            this.buildDefaultViewAllQuery();
        }
        return this;
    }

    private void buildDefaultViewAllQuery() {
        this.viewAllQuery = this.getResultCount() > 0 ? this.buildTextSearchQuery(this.originalQuery) : JqlQueryBuilder.newBuilder().orderBy().lastViewedDate(SortOrder.DESC).buildQuery();
    }

    public List<Issue> getResults() {
        return this.results;
    }

    Query getViewAllQuery() {
        return this.viewAllQuery;
    }

    private void extractIssueKey() {
        Optional<Pattern> issueKeyPattern = this.projectKeyHelper.getIssueKeyPattern();
        if (issueKeyPattern.isPresent()) {
            Matcher matcher = issueKeyPattern.get().matcher(this.originalQuery);
            while (matcher.find()) {
                if (this.issueKey != null) {
                    this.issueKey = null;
                    this.hasWholeIssueKey = false;
                    return;
                }
                String rawIssueKey = this.projectKeyHelper.getIssueKey(matcher);
                this.issueKey = rawIssueKey.toUpperCase();
                this.hasWholeIssueKey = !StringUtils.isBlank((String)this.projectKeyHelper.getIssueNumber(matcher));
                this.issueKeyRefinementQuery = this.originalQuery.replace(rawIssueKey, "").trim();
            }
        }
    }

    private Query buildTextSearchQuery(String query) {
        String textQuery = ProductSearchTextUtils.createWildcardLuceneQuery(query);
        return JqlQueryBuilder.newBuilder().where().summary().like(textQuery).or().description().like(textQuery).endWhere().orderBy().addSortForFieldName(LAST_VIEWED_FIELD, SortOrder.DESC, false).buildQuery();
    }

    private void searchSummaryDescription() throws SearchException {
        List<Issue> searchResults;
        Query textSearchQuery;
        if (StringUtils.isEmpty((String)this.originalQuery)) {
            return;
        }
        Query retrieveIssuesQuery = textSearchQuery = this.buildTextSearchQuery(this.originalQuery);
        if (this.getResultCount() > 0) {
            String[] excludedIssues = this.results.stream().map(Issue::getKey).collect(Collectors.toList()).toArray(new String[this.getResultCount()]);
            retrieveIssuesQuery = JqlQueryBuilder.newBuilder((Query)retrieveIssuesQuery).where().and().not().issue().in(excludedIssues).buildQuery();
        }
        if (!(searchResults = this.search(retrieveIssuesQuery, this.getResultsRemaining())).isEmpty()) {
            this.results.addAll(searchResults);
            this.mergeViewAllQuery(textSearchQuery);
        }
    }

    private void mergeViewAllQuery(Query query) {
        this.viewAllQuery = JqlQueryBuilder.newBuilder((Query)this.viewAllQuery).where().or().addClause(query.getWhereClause()).endWhere().orderBy().setSorts(query.getOrderByClause()).buildQuery();
    }

    private void searchIssueKeyRange() throws SearchException {
        if (this.issueKey == null) {
            return;
        }
        List<String> keyRange = Stream.concat(IntStream.rangeClosed(0, 9).mapToObj(i -> this.issueKey + i), Stream.of(this.issueKey)).collect(Collectors.toList());
        if (StringUtils.isNotBlank((String)this.issueKeyRefinementQuery)) {
            this.refineIssueKeySearch(keyRange);
        } else {
            Optional<Query> keyRangeQuery = this.keyCollectionQuery(this.issueKey, keyRange);
            if (keyRangeQuery.isPresent()) {
                List<Issue> issueRange = this.search(keyRangeQuery.get(), this.getResultsRemaining());
                this.results.addAll(issueRange);
                if (this.hasWholeIssueKey) {
                    this.viewAllQuery = this.keyCollectionQuery(this.issueKey, issueRange.stream().map(Issue::getKey).collect(Collectors.toList())).orElse(this.viewAllQuery);
                }
            }
        }
    }

    private void refineIssueKeySearch(Collection<String> keyRange) throws SearchException {
        Query refinedQuery;
        List<Issue> searchResults;
        Optional<Query> keyRangeQuery = this.keyCollectionQuery(this.issueKey, keyRange);
        if (keyRangeQuery.isPresent() && !(searchResults = this.search(refinedQuery = this.addTextSearchToQuery(keyRangeQuery.get(), this.issueKeyRefinementQuery), this.getResultsRemaining())).isEmpty()) {
            this.results.addAll(searchResults);
            Optional<Query> filteredKeys = this.keyCollectionQuery(this.issueKey, searchResults.stream().map(Issue::getKey).collect(Collectors.toList()));
            this.viewAllQuery = filteredKeys.map(keys -> this.addTextSearchToQuery((Query)keys, this.issueKeyRefinementQuery)).orElse(this.viewAllQuery);
        }
    }

    private Query addTextSearchToQuery(Query baseQuery, String refinement) {
        return JqlQueryBuilder.newBuilder((Query)baseQuery).where().and().addClause(this.buildTextSearchQuery(refinement).getWhereClause()).buildQuery();
    }

    private Optional<Query> keyCollectionQuery(String issueKey, Collection<String> keyRange) {
        if (keyRange.size() > 1) {
            return Optional.of(JqlQueryBuilder.newBuilder().where().issue().in(keyRange.toArray(new String[keyRange.size()])).endWhere().orderBy().issueKey(SortOrder.ASC).buildQuery());
        }
        if (keyRange.size() == 1) {
            return Optional.of(JqlQueryBuilder.newBuilder().where().issue().eq(issueKey.toUpperCase()).endWhere().buildQuery());
        }
        return Optional.empty();
    }

    private List<Issue> search(Query query, int resultLimit) throws SearchException {
        this.searchProvider.disableCacheForRequest();
        SearchResults results = this.searchProvider.search(query, this.jiraAuthenticationContext.getUser(), PagerFilter.newPageAlignedFilter((int)0, (int)resultLimit));
        List<Object> result = new ArrayList<Issue>();
        if (results != null) {
            result = results.getIssues();
        }
        return result;
    }

    private int getResultCount() {
        return this.results.size();
    }

    private boolean needsMoreResults() {
        return this.getResultCount() < this.maximumItemCount;
    }

    private int getResultsRemaining() {
        return this.maximumItemCount - this.getResultCount();
    }
}

