/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.quicksearch.impl;

import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.IndexSearcher;
import org.springframework.stereotype.Component;

@Component
public class IndexStatisticsHelper {
    private final SearchProviderFactory searchProviderFactory;

    public IndexStatisticsHelper(@ComponentImport SearchProviderFactory searchProviderFactory) {
        this.searchProviderFactory = searchProviderFactory;
    }

    public IndexStatistics getIndexStatistics() throws IOException {
        IndexSearcher searcher = this.searchProviderFactory.getSearcher("issues");
        SegmentInfos si = new SegmentInfos();
        IndexReader indexReader = searcher.getIndexReader();
        si.read(indexReader.directory());
        return new IndexStatistics(indexReader.maxDoc(), indexReader.numDeletedDocs(), si.size());
    }

    @Immutable
    public static class IndexStatistics {
        private final long numDocs;
        private final long numDeletedDocs;
        private final long numSegments;

        public IndexStatistics(long numDocs, long numDeletedDocs, long numSegments) {
            this.numDocs = numDocs;
            this.numDeletedDocs = numDeletedDocs;
            this.numSegments = numSegments;
        }

        public long getNumDocs() {
            return this.numDocs;
        }

        public long getNumDeletedDocs() {
            return this.numDeletedDocs;
        }

        public long getNumSegments() {
            return this.numSegments;
        }
    }
}

