/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.quicksearch.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.quicksearch.api.QueryLimiter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultQueryLimiter
implements QueryLimiter {
    private final ApplicationProperties applicationProperties;
    private final int DEFAULT_MAX_CONCURRENT_SEARCHES = 20;
    private final AtomicInteger currentSearchNum = new AtomicInteger();

    @Autowired
    public DefaultQueryLimiter(@ComponentImport ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryLimiter.QueryResponse getResponseWithLimit(Supplier<Response> responseSupplier, Response quotaExceededResponse) {
        long limit = this.getConcurrentSearchLimit();
        QueryLimiter.QueryStatistics.QueryStatisticsBuilder queryStatisticsBuilder = QueryLimiter.QueryStatistics.builder();
        queryStatisticsBuilder.setExecuted(false);
        queryStatisticsBuilder.setStart(System.currentTimeMillis());
        queryStatisticsBuilder.setCurrentLimit(limit);
        try {
            int currentlyRunning = this.currentSearchNum.incrementAndGet();
            queryStatisticsBuilder.setCurrentlyRunning(currentlyRunning);
            if ((long)currentlyRunning <= limit) {
                Response resp = responseSupplier.get();
                queryStatisticsBuilder.setStop(System.currentTimeMillis());
                queryStatisticsBuilder.setExecuted(true);
                QueryLimiter.QueryResponse queryResponse = new QueryLimiter.QueryResponse(resp, queryStatisticsBuilder.build());
                return queryResponse;
            }
        }
        finally {
            this.currentSearchNum.decrementAndGet();
        }
        queryStatisticsBuilder.setStop(System.currentTimeMillis());
        return new QueryLimiter.QueryResponse(quotaExceededResponse, queryStatisticsBuilder.build());
    }

    @Override
    public long getConcurrentSearchNum() {
        return this.currentSearchNum.get();
    }

    @Override
    public long getConcurrentSearchLimit() {
        String labelString = this.applicationProperties.getDefaultBackedString("jira.quicksearch.max.concurrent.searches");
        long limit = 20L;
        if (StringUtils.isNumeric((String)labelString)) {
            try {
                limit = Long.parseLong(labelString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return limit;
    }
}

