/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.quicksearch.impl;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.quicksearch.api.QueryLimiter;
import com.atlassian.jira.plugins.quicksearch.events.QueryPerformanceEvent;
import com.atlassian.jira.plugins.quicksearch.impl.IndexStatisticsHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsHelper {
    final EventPublisher eventPublisher;
    final IndexStatisticsHelper indexStatisticsHelper;

    public AnalyticsHelper(@ComponentImport EventPublisher eventPublisher, IndexStatisticsHelper indexStatisticsHelper) {
        this.eventPublisher = eventPublisher;
        this.indexStatisticsHelper = indexStatisticsHelper;
    }

    public void sendAnalytics(String query, QueryLimiter.QueryResponse queryResponse) {
        Object entity;
        QueryPerformanceEvent.QueryPerformanceEventBuilder builder = QueryPerformanceEvent.builder();
        Response response = queryResponse.getResponse();
        QueryLimiter.QueryStatistics queryStatistics = queryResponse.getStatistics();
        builder.setIdxSegmentCount(-1L);
        builder.setIdxDeletedDocumentCount(-1L);
        builder.setIdxDocumentCount(-1L);
        if (queryStatistics.isExecuted()) {
            try {
                IndexStatisticsHelper.IndexStatistics indexStatistics = this.indexStatisticsHelper.getIndexStatistics();
                builder.setIdxSegmentCount(indexStatistics.getNumSegments());
                builder.setIdxDeletedDocumentCount(indexStatistics.getNumDeletedDocs());
                builder.setIdxDocumentCount(indexStatistics.getNumDocs());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        builder.setQueryLength(StringUtils.defaultString((String)query).length());
        builder.setHasResults(false);
        builder.setExecuted(queryStatistics.isExecuted());
        builder.setThreadLimit(queryStatistics.getCurrentLimit());
        builder.setCurrentThreadCount(queryStatistics.getCurrentlyRunning());
        builder.setStart(queryStatistics.getStart());
        builder.setStop(queryStatistics.getStop());
        if (response.getStatus() == Response.Status.OK.getStatusCode() && Objects.nonNull(entity = response.getEntity()) && entity instanceof List) {
            List list = (List)entity;
            boolean hasResults = list.stream().filter(rg -> "quick-search-issues".equals(rg.getId())).anyMatch(rg -> !rg.getItems().isEmpty());
            builder.setHasResults(hasResults);
        }
        this.eventPublisher.publish((Object)builder.build());
    }
}

