/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.quicksearch.events;

import com.atlassian.analytics.api.annotations.EventName;

@EventName(value="quicksearch.query.performance.event")
public class QueryPerformanceEvent {
    final long start;
    final long stop;
    final long duration;
    final long threadLimit;
    final long currentThreadCount;
    final boolean executed;
    final boolean hasResults;
    final long queryLength;
    final long idxDocumentCount;
    final long idxDeletedDocumentCount;
    final long idxSegmentCount;

    private QueryPerformanceEvent(long start, long stop, long duration, long threadLimit, long currentThreadCount, boolean executed, boolean hasResults, long queryLength, long idxDocumentCount, long idxDeletedDocumentCount, long idxSegmentCount) {
        this.start = start;
        this.stop = stop;
        this.duration = duration;
        this.threadLimit = threadLimit;
        this.currentThreadCount = currentThreadCount;
        this.executed = executed;
        this.hasResults = hasResults;
        this.queryLength = queryLength;
        this.idxDocumentCount = idxDocumentCount;
        this.idxDeletedDocumentCount = idxDeletedDocumentCount;
        this.idxSegmentCount = idxSegmentCount;
    }

    public long getStart() {
        return this.start;
    }

    public long getStop() {
        return this.stop;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getThreadLimit() {
        return this.threadLimit;
    }

    public long getCurrentThreadCount() {
        return this.currentThreadCount;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public boolean isHasResults() {
        return this.hasResults;
    }

    public long getQueryLength() {
        return this.queryLength;
    }

    public long getIdxDocumentCount() {
        return this.idxDocumentCount;
    }

    public long getIdxDeletedDocumentCount() {
        return this.idxDeletedDocumentCount;
    }

    public long getIdxSegmentCount() {
        return this.idxSegmentCount;
    }

    public String toString() {
        return "QueryPerformanceEvent{start=" + this.start + ", stop=" + this.stop + ", duration=" + this.duration + ", threadLimit=" + this.threadLimit + ", currentThreadCount=" + this.currentThreadCount + ", executed=" + this.executed + ", hasResults=" + this.hasResults + ", queryLength=" + this.queryLength + ", idxDocumentCount=" + this.idxDocumentCount + ", idxDeletedDocumentCount=" + this.idxDeletedDocumentCount + ", idxSegmentCount=" + this.idxSegmentCount + '}';
    }

    public static QueryPerformanceEventBuilder builder() {
        return new QueryPerformanceEventBuilder();
    }

    public static class QueryPerformanceEventBuilder {
        private long start;
        private long stop;
        private long threadLimit;
        private long currentThreadCount;
        private boolean executed;
        private boolean hasResults;
        private long queryLength;
        private long idxDocumentCount;
        private long idxDeletedDocumentCount;
        private long idxSegmentCount;

        public QueryPerformanceEventBuilder setStart(long start) {
            this.start = start;
            return this;
        }

        public QueryPerformanceEventBuilder setStop(long stop) {
            this.stop = stop;
            return this;
        }

        public QueryPerformanceEventBuilder setThreadLimit(long threadLimit) {
            this.threadLimit = threadLimit;
            return this;
        }

        public QueryPerformanceEventBuilder setCurrentThreadCount(long currentThreadCount) {
            this.currentThreadCount = currentThreadCount;
            return this;
        }

        public QueryPerformanceEventBuilder setExecuted(boolean executed) {
            this.executed = executed;
            return this;
        }

        public QueryPerformanceEventBuilder setHasResults(boolean hasResults) {
            this.hasResults = hasResults;
            return this;
        }

        public QueryPerformanceEventBuilder setQueryLength(long queryLength) {
            this.queryLength = queryLength;
            return this;
        }

        public QueryPerformanceEventBuilder setIdxDocumentCount(long idxDocumentCount) {
            this.idxDocumentCount = idxDocumentCount;
            return this;
        }

        public QueryPerformanceEventBuilder setIdxDeletedDocumentCount(long idxDeletedDocumentCount) {
            this.idxDeletedDocumentCount = idxDeletedDocumentCount;
            return this;
        }

        public QueryPerformanceEventBuilder setIdxSegmentCount(long idxSegmentCount) {
            this.idxSegmentCount = idxSegmentCount;
            return this;
        }

        public QueryPerformanceEvent build() {
            return new QueryPerformanceEvent(this.start, this.stop, this.stop - this.start, this.threadLimit, this.currentThreadCount, this.executed, this.hasResults, this.queryLength, this.idxDocumentCount, this.idxDeletedDocumentCount, this.idxSegmentCount);
        }
    }
}

