/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.quicksearch.api;

import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import javax.ws.rs.core.Response;

public interface QueryLimiter {
    public QueryResponse getResponseWithLimit(Supplier<Response> var1, Response var2);

    public long getConcurrentSearchNum();

    public long getConcurrentSearchLimit();

    @Immutable
    public static class QueryStatistics {
        private final long start;
        private final long stop;
        private final long currentLimit;
        private final long currentlyRunning;
        private final boolean executed;

        private QueryStatistics(long start, long stop, long currentLimit, long currentlyRunning, boolean executed) {
            this.start = start;
            this.stop = stop;
            this.currentLimit = currentLimit;
            this.currentlyRunning = currentlyRunning;
            this.executed = executed;
        }

        public long getStart() {
            return this.start;
        }

        public long getStop() {
            return this.stop;
        }

        public long getCurrentLimit() {
            return this.currentLimit;
        }

        public long getCurrentlyRunning() {
            return this.currentlyRunning;
        }

        public boolean isExecuted() {
            return this.executed;
        }

        public static QueryStatisticsBuilder builder() {
            return new QueryStatisticsBuilder();
        }

        public static class QueryStatisticsBuilder {
            private long start;
            private long stop;
            private long currentLimit;
            private long currentlyRunning;
            private boolean executed;

            public QueryStatisticsBuilder setStart(long start) {
                this.start = start;
                return this;
            }

            public QueryStatisticsBuilder setStop(long stop) {
                this.stop = stop;
                return this;
            }

            public QueryStatisticsBuilder setCurrentLimit(long currentLimit) {
                this.currentLimit = currentLimit;
                return this;
            }

            public QueryStatisticsBuilder setCurrentlyRunning(long currentlyRunning) {
                this.currentlyRunning = currentlyRunning;
                return this;
            }

            public QueryStatisticsBuilder setExecuted(boolean executed) {
                this.executed = executed;
                return this;
            }

            public QueryStatistics build() {
                return new QueryStatistics(this.start, this.stop, this.currentLimit, this.currentlyRunning, this.executed);
            }
        }
    }

    @Immutable
    public static class QueryResponse {
        private final Response response;
        private final QueryStatistics statistics;

        public QueryResponse(Response response, QueryStatistics statistics) {
            this.response = response;
            this.statistics = statistics;
        }

        public Response getResponse() {
            return this.response;
        }

        public QueryStatistics getStatistics() {
            return this.statistics;
        }
    }
}

